package org.dromara.zjk.domain.excels;

import com.alibaba.excel.annotation.ExcelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.dromara.common.excel.annotation.ExcelDictFormat;
import org.dromara.common.excel.convert.ExcelDictConvert;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class ZjkProductSummarizeExcelVO {

    @ExcelProperty(value = "所属项目")
    private String productName;

    @ExcelProperty(value = "项目总结名称")
    private String productSummarizeName;

    @ExcelProperty(value = "项目总结分类",converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = "summarize_classify")
    private String productSummarizeType;


    @ExcelProperty(value = "项目阶段",converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = "item_stage")
    private String reviewSn;


    @ExcelProperty("项目概况不能为空")
    private String productGeneral;


    @ExcelProperty("审批范围不能为空")
    private String reviewScope;


    @ExcelProperty("审批结论不能为空")
    private String reviewConclusion;


    @ExcelProperty("反馈")
    private String feedback;


    @ExcelProperty("后续改进措施不能为空")
    private String subsequent;
}
