package org.dromara.zjk.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.dromara.common.core.utils.StringUtils;
import org.dromara.common.excel.annotation.ExcelDictFormat;
import org.dromara.common.excel.convert.ExcelDictConvert;
import org.dromara.common.excel.convert.MultiDictConvert;
import org.dromara.resource.api.domain.RemoteFile;
import org.dromara.zjk.annotation.PropertyMsg;
import org.dromara.zjk.annualInspection.annualInspectionAudit.domain.ZjkAnnualInspection;
import org.dromara.zjk.domain.ZjkExpert;
import org.dromara.zjk.domain.ZjkExpertMajor;
import org.dromara.zjk.domain.ZjkExpertProfessional;
import org.dromara.zjk.expert.expertAwards.domain.ZjkExpertAwards;
import org.dromara.zjk.expert.expertPaper.domain.ZjkExpertPaper;
import org.dromara.zjk.expert.expertPatent.domain.ZjkExpertPatent;
import org.dromara.zjk.zwy.annotation.EncryptSensitive;

import java.io.Serial;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;


/**
 * expert视图对象 zjk_expert
 *
 * @author wangtong
 * @date 2024-10-24
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkExpert.class)
@EqualsAndHashCode
public class ZjkExpertVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    private Long expertId;

    /**
     * 姓名
     */
    @ExcelProperty(value = "姓名")
    private String expertName;

    /**
     * 性别
     */
    @ExcelProperty(value = "性别", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = "sys_user_sex")
    private Long sex;

    /**
     * 生日
     */
    @ExcelProperty(value = "生日")
    private Date birthDate;

    /**
     * 身份证号
     */
    @EncryptSensitive
    private String idCard;

    /**
     * 联系方式
     */
    @ExcelProperty(value = "联系方式")
    @EncryptSensitive
    private String contact;

    /**
     * 工作单位
     */
    @ExcelProperty(value = "工作单位")
    private String workUnit;
    /**
     * 详细地址
     */
    private String address;

    /**
     * 职务
     */
    @ExcelProperty(value = "职务")
    private String duty;

    /**
     * 政治面貌
     */
    private String politics;

    /**
     * 毕业学校
     */
    private String graduateSchool;

    /**
     * 专业
     */
    private String major;

    /**
     * 邮箱
     */
    @EncryptSensitive
    private String email;

    @ExcelDictFormat(dictType = "degree_type")
    private String degree;
    /**
     * 专业技术资格
     */
    private String professional;

    /**
     * 专业技术资格取得时间
     */
    private Date professionalAcquisitionDate;

    /**
     * 从事专业
     */
    private String workProfessial;

    /**
     * 从事专业年限
     */
    private Integer workProfessialYear;

    /**
     * 照片
     */
    private String photograph;

    /**
     * 从事工作或研究领域
     */
    private String performWorkId;

    /**
     * 其他领域描述
     */
    private String otherDescribe;

    /**
     * 主要工作经历
     */
    private String workExperience;

    /**
     * 社会兼职情况
     */
    private String workPluralistic;

    /**
     * 主要论著、业绩成果及获奖情况
     */
    private String achievement;

    /**
     * 论文
     */
    private String paperpath;

    /**
     * 专利
     */
    private String patentpath;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建人
     */
    private Long createdBy;

    /**
     * 创建时间
     */
    private Date createdTime;

    /**
     * 修改人
     */
    private Long updatedBy;

    /**
     * 修改时间
     */
    private Date updatedTime;

    /**
     * 是否删除
     */
    private Long deleteFlag;

    /**
     * 是否启用
     */
    private Integer useFlag;

    /**
     * 状态: 0：暂存 1：待审批 2：正常  3：拒绝 4 离职 5退休
     */
    private Integer status;

    /**
     * 登录用户id
     */
    private Long userId;

    /**
     * 审批类型  0 专家申请    1 信息变更
     */
    private Integer approvalType;


    /**
     * 单位类型   1企业，2高校，3政府单位
     */
    private String unitType;

    /**
     * 是否专家推荐 1 是 2 否
     */
    private Integer isRecommend;

    /**
     * 省
     */
    private String province;

    /**
     * 市
     */
    private String city;

    /**
     * 区
     */
    private String area;


    /**
     * 专业关系表对象
     */
    private List<ZjkExpertMajor> majorList;

    /*
    专家库技术资格关系表对象
     */
    private List<ZjkExpertProfessional> professionalList;

    /*
    获奖情况
     */
    private List<ZjkExpertAwards> zjkExpertAwardsList;

    /*
    论文信息
     */
    private List<ZjkExpertPaper> zjkExpertPaperList;

    /*
    专利信息
     */
    private List<ZjkExpertPatent> zjkExpertPatentList;

    /**
     * 发生变化的字段
     */
    private String modifiedFields;
    /**
     * 接受状态（1：已接受；0：未接受；2：拒绝; 4：取消）
     */
    private Integer acceptStatus;

    /**
     * 年检状态(1 待年检 2 已通过 3 未通过)
     */
    private String annualInspectionStatus;

    /**
     * 年检时间
     */
    private String annualInspectionTime;

    /**
     * 审批时间
     */
    private Date approvalTime;


    private String userName;

    private String avatar;


    private String deptName;


    /**
     * 专家来源 1 省内 2 省外
     */
    @ExcelProperty(value = "专家来源", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = "expert_sources")
    private String expertSources;


    /**
     * 其他附件
     */
    @PropertyMsg(propertyName = "其他附件")
    private String otherPath;

    /**
     * 离职退休息时间
     */
    private Date retirementTime;

    private ZjkAnnualInspection zjkAnnualInspection;

    private String rewardType;
    private String rewardId;

    /**
     * 其他附件集合
     */
    List<RemoteFile> otherPathList;

    @PropertyMsg(propertyName = "项目参与数量")
    private Long productCount;

    /**
     * 职称等级
     */
    @PropertyMsg(propertyName = "职称等级")
    private Long positionTitleLevel;

    private String positionTitleLevelStr;

    /*
     * 抽取的数据来源
     * */
    private Integer isSource;

    //2024/12/3 add返回字段   抽取状态(0:取消，1:确认，2:重抽)    页面进行显示      枚举类ExtractionStatusEnum
    private Integer extractionStatus;

    public List<String> getAreaList() {
        if (StringUtils.isEmpty(performWorkId)) {
            return new ArrayList<>();
        }
        return Arrays.asList(performWorkId.split(","));
    }

    @PropertyMsg(propertyName = "籍贯")
    private String origin;

    private String unitTypeDescribe;

    private String hmac;
    /**
     * 活动范围
     */
    private String scopeOfActivity;
    /**
     * 是否涉密0:不涉密  1：涉密
     */
    private Integer isClassified;
}
