package org.dromara.zjk.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import org.dromara.common.excel.annotation.ExcelDictFormat;
import org.dromara.common.excel.convert.ExcelDictConvert;
import org.dromara.zjk.domain.ZjkLeave;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;



/**
 * 【请填写功能名称】视图对象 zjk_leave
 *
 * @author ygh
 * @date 2024-10-30
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkLeave.class)
public class ZjkLeaveVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * $column.columnComment
     */
    @ExcelProperty(value = "${comment}", converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "$column.readConverterExp()")
    private String gid;

    /**
     * $column.columnComment
     */
    @ExcelProperty(value = "请假类型", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = "qjlx")
    private String leaveType;

    /**
     * $column.columnComment
     */
    @ExcelProperty(value = "${comment}", converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "$column.readConverterExp()")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date startDate;

    /**
     * $column.columnComment
     */
    @ExcelProperty(value = "${comment}", converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "$column.readConverterExp()")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date endDate;

    /**
     * $column.columnComment
     */
    @ExcelProperty(value = "${comment}", converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "$column.readConverterExp()")
    private Long leaveDays;

    /**
     * $column.columnComment
     */
    @ExcelProperty(value = "${comment}", converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "$column.readConverterExp()")
    private String leaveReason;

    /**
     * $column.columnComment
     */
    @ExcelProperty(value = "请假状态", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = "approval_status")
    private String status;

    /**
     * $column.columnComment
     */
    @ExcelProperty(value = "${comment}", converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "$column.readConverterExp()")
    private String approvalUser;

    /**
     * $column.columnComment
     */
    @ExcelProperty(value = "${comment}", converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "$column.readConverterExp()")
    private String approvalMsg;

    private String createBy;
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date createTime;

    private String expertName;

}
