package org.dromara.zjk.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import org.dromara.zjk.domain.ZjkExpert;
import org.dromara.zjk.domain.ZjkProductSummarize;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import org.dromara.common.excel.annotation.ExcelDictFormat;
import org.dromara.common.excel.convert.ExcelDictConvert;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import org.dromara.zjk.domain.ZjkProjectEvaluation;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;
import java.util.List;


/**
 * 项目总结视图对象 zjk_product_summarize
 *
 * @author ygh
 * @date 2024-11-02
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkProductSummarize.class)
public class ZjkProductSummarizeVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    private String search;

    /**
     * id
     */
    @ExcelProperty(value = "项目总结编号")
    private Long id;

    /**
     * 专家抽取id
     */
    private Long reviewId;

    /**
     * 总结名称
     */
    @ExcelProperty(value = "总结名称")
    private String productSummarizeName;

    /**
     * 总结类型
     */
    @ExcelProperty(value = "总结分类", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = "summarize_classify")
    private String productSummarizeType;
    /**
     * 备注
     */
    @ExcelProperty(value = "总结标签")
    private String remark;
    @ExcelProperty(value = "所属项目")
    private String productName;
    /**
     * 状态
     */
    @ExcelProperty(value = "总结状态", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = "summarize_status")
    private String status;

    private String statusName;
    private String productSummarizeTypeName;

    /**
     * 项目概况
     */
    private String productGeneral;

    /**
     * 评审范围
     */
    private String reviewScope;

    /**
     * 评审结论
     */
    private String reviewConclusion;

    /**
     * 反馈
     */
    private String feedback;

    /**
     * 后续改进措施
     */
    private String subsequent;

    /**
     * 附件
     */
    private String attachment;

    /**
     * 专家id
     */
    private String expertIds;






    @ExcelProperty(value = "项目时间")
    private Date reviewTime;

    @ExcelIgnore
    private List<ZjkExpertVo> zjkExpertList;


    private Long productId;

    private String reviewSn;

    private Date createTime;

    private ZjkProjectEvaluation zjkProjectEvaluation;
}
