package org.dromara.zjk.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.dromara.common.sensitive.annotation.Sensitive;
import org.dromara.common.sensitive.core.SensitiveStrategy;
import org.dromara.zjk.domain.ZjkProduct;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import org.dromara.common.excel.annotation.ExcelDictFormat;
import org.dromara.common.excel.convert.ExcelDictConvert;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import org.dromara.zjk.expert.expertPaper.domain.ZjkExpertPaper;
import org.dromara.zjk.expert.expertPatent.domain.ZjkExpertPatent;
import org.dromara.zjk.zwy.annotation.EncryptSensitive;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;
import java.util.List;


/**
 * 项目管理视图对象 zjk_product
 *
 * @author ygh
 * @date 2024-11-01
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkProduct.class)
public class ZjkProductVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * $column.columnComment
     */
    @ExcelIgnore
    private Long id;

    /**
     * $column.columnComment
     */
    @ExcelProperty(value = "项目编号")
    private String productSn;

    /**
     * $column.columnComment
     */
    @ExcelProperty(value = "项目名称")
    private String productName;

    /**
     * $column.columnComment
     */
    @ExcelProperty(value = "项目类型")
    private String productType;

    /**
     * $column.columnComment
     */
    @ExcelProperty(value = "项目规模")
    private Integer productScale;

    /**
     * $column.columnComment
     */
    @ExcelProperty(value = "项目单位")
    private String productUnit;

    /**
     * $column.columnComment
     */
    @ExcelProperty(value = "联系人")
    private String unitBy;

    /**
     * $column.columnComment
     */

    @EncryptSensitive
    @ExcelProperty(value = "联系方式")
    private String unitConcat;

    /**
     * $column.columnComment
     */
    @ExcelProperty(value = "简介")
    private String productBrief;

    /**
     * $column.columnComment
     */
    private String productDataUrl;

    /**
     * $column.columnComment
     */
    private Long status;

    /**
     * $column.columnComment
     */
    private String remark;

    private Long reviewId;

    private List<String> statusList;

    private Long  productId;

    private int isItem;

    private String reviewSn;

    private Long productReviewId;
    private Integer approvalStatus;
    private String approvalReason;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    /**
     * 项目论文
     */
    private List<ZjkExpertPaper> zjkExpertPaperList;

    /**
     * 项目专利
     */
    private List<ZjkExpertPatent> zjkExpertPatentsList;

    private String hmac;
}
