package org.dromara.zjk.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.dromara.zjk.zwy.annotation.EncryptSensitive;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;
import java.util.List;


/**
 * 专家抽取视图对象 zjk_item_extreation
 *
 * @author ygh
 * @date 2024-10-29
 */
@Data
public class ZjkReviewExportVo implements Serializable {




    /**
     * 项目名称
     */
    @ExcelProperty(value = "项目编号")
    private String productSn;

    /**
     * 项目名称
     */
    @ExcelProperty(value = "项目名称")
    private String productName;


    /**
     * 项目单位
     */
    @ExcelProperty(value = "项目单位")
    private String productUnit;

    /**
     * 联系人
     */
    @ExcelProperty(value = "联系人")
    private String unitBy;

    /**
     * 联系方式
     */
    @EncryptSensitive
    @ExcelProperty(value = "联系方式")
    private String unitConcat;

    /**
     * 评审阶段
     */
    @ExcelProperty(value = "评审阶段")
    private String reviewSn;

    /**
     * 评审时间
     */
    /**
     * 评审时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ExcelProperty(value = "评审时间")
    private Date reviewTime;
}
