package org.dromara.zjk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum ReviewSnEnum {
    PROJECT_APPROVAL("1","立项"),
    CALL_BIDS("2","招标"),
    PRELIMINARY_ACCEPTANCE("3","初验"),
    FINAL_ACCEPTANCE("4","终验");



    /**
     * 状态
     */
    private final String code;

    /**
     * 描述
     */
    private final String desc;
    /**
     * 通过描述获取编码
     *
     * @param desc 描述
     * @return 编码
     */
    public static Integer getCodeByDesc(String desc) {
        for (ReviewSnEnum status : ReviewSnEnum.values()) {
            if (status.getDesc().equals(desc)) {
                return Integer.valueOf(status.getCode());
            }
        }
        return null; // 找不到对应描述的枚举值时返回 null
    }
    public static String getDescByCode(String code) {
        for (ReviewSnEnum status : ReviewSnEnum.values()) {
            if (status.getCode().equals(code)) {
                return status.getDesc();
            }
        }
        return null; // 找不到对应描述的枚举值时返回 null
    }
    public static ReviewSnEnum getByCode(String code) {
        for (ReviewSnEnum status : ReviewSnEnum.values()) {
            if (status.getCode().equals( code)) {
                return status;
            }
        }
        return null; // 找不到对应 code 的枚举值时返回 null
    }
}
