package org.dromara.zjk.expert.expertAwards.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.dromara.common.tenant.core.TenantEntity;
import org.dromara.zjk.annotation.PropertyMsg;

import java.io.Serial;

/**
 * 专家获奖情况对象 zjk_expert_awards
 *
 * @author zhangzhou
 * @date 2024-11-10
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("zjk_expert_awards")
public class ZjkExpertAwards extends TenantEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    private Long id;

    /**
     * 专家 id
     */
    private Long expertId;

    /**
     * 获奖证书文件路径
     */
//    @PropertyMsg(propertyName = "获奖证书附件")
    private String awardsPath;

    /**
     * 获奖内容
     */
    @PropertyMsg(propertyName = "执业资格证书名称")
    private String awardsContent;

    @PropertyMsg(propertyName = "注册号")
    private String registerSn;

    /**
     * 逻辑删除
     */
    private Long delFlag;
    /**
     * 原名
     */
    @TableField(exist = false)
    private String originalName;

    /**
     * 文件后缀名
     */
    @TableField(exist = false)
    private String fileSuffix;

    /**
     * url
     */
    @TableField(exist = false)
    private String url;


}
