package org.dromara.zjk.expert.expertAwards.service;

import org.dromara.common.mybatis.core.page.PageQuery;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.zjk.expert.expertAwards.domain.ZjkExpertAwards;
import org.dromara.zjk.expert.expertAwards.domain.bo.ZjkExpertAwardsBo;
import org.dromara.zjk.expert.expertAwards.domain.vo.ZjkExpertAwardsVo;

import java.util.Collection;
import java.util.List;

/**
 * 专家获奖情况Service接口
 *
 * @author zhangzhou
 * @date 2024-11-10
 */
public interface IZjkExpertAwardsService {

    /**
     * 查询专家获奖情况
     *
     * @param id 主键
     * @return 专家获奖情况
     */
    ZjkExpertAwardsVo queryById(Long id);

    /**
     * 分页查询专家获奖情况列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 专家获奖情况分页列表
     */
    TableDataInfo<ZjkExpertAwardsVo> queryPageList(ZjkExpertAwardsBo bo, PageQuery pageQuery);

    /**
     * 查询符合条件的专家获奖情况列表
     *
     * @param bo 查询条件
     * @return 专家获奖情况列表
     */
    List<ZjkExpertAwardsVo> queryList(ZjkExpertAwardsBo bo);

    /**
     * 新增专家获奖情况
     *
     * @param bo 专家获奖情况
     * @return 是否新增成功
     */
    Boolean insertByBo(ZjkExpertAwardsBo bo);

    /**
     * 修改专家获奖情况
     *
     * @param bo 专家获奖情况
     * @return 是否修改成功
     */
    Boolean updateByBo(ZjkExpertAwardsBo bo);

    /**
     * 校验并批量删除专家获奖情况信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);

    /**
     * 专家 id 进行 新增获奖情况信息
     * @param zjkExpertAwardsList
     * @param expertId
     */
    void handleExpertAwards(List<ZjkExpertAwards> zjkExpertAwardsList, Long expertId);


    /**
     * 根据专家 id 获取获奖情况信息
     * @param expertId
     * @return
     */
    List<ZjkExpertAwards> populateExpertAwardsList(Long expertId);


    List<ZjkExpertAwards> selectByExpertId(Long expertId);
}
