package org.dromara.zjk.expert.retirementRecords.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;

import org.dromara.common.excel.annotation.ExcelDictFormat;
import org.dromara.common.excel.convert.ExcelDictConvert;
import org.dromara.zjk.zwy.annotation.EncryptSensitive;
import org.dromara.zjk.annotation.PropertyMsg;
import org.dromara.zjk.expert.retirementRecords.domain.ZjkRetirementRecords;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;



/**
 * 专家退休记录视图对象 zjk_retirement_records
 *
 * @author zhangzhou
 * @date 2024-11-19
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkRetirementRecords.class)
public class ZjkRetirementRecordsVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @ExcelProperty(value = "id")
    private Long id;

    /**
     * 专家 id
     */
    @ExcelProperty(value = "专家 id")
    private Long expertId;

    /**
     * 用户 id
     */
    @ExcelProperty(value = "用户 id")
    private Long userId;

    /**
     * 退休时间
     */
    @ExcelProperty(value = "退休时间")
    private Date retirementTime;

    /**
     * 离职原因
     */
    @PropertyMsg(propertyName = "离职原因")
    private String reason;

    /**
     * 附件
     */
    @PropertyMsg(propertyName = " 附件")
    private String filePath;

    /**
     * 专家状态 4 离职 5退休
     */
    @ExcelProperty(value = "专家状态 4 离职 5退休", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = "expert_status")
    private String expertStatus;

    @ExcelProperty(value = "专家姓名")
    private String expertName;

    @ExcelProperty(value = "联系方式")
    @EncryptSensitive
    private String contact;

    @ExcelProperty(value = "身份证号")
    @EncryptSensitive
    private String idCard;

    @ExcelProperty(value = "工作单位")
    private String workUnit;


}
