package org.dromara.zjk.learning_world.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import org.dromara.common.excel.annotation.ExcelDictFormat;
import org.dromara.common.excel.convert.ExcelDictConvert;
import org.dromara.zjk.learning_world.domain.entity.ZjkLearningCommont;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;
import java.util.List;


/**
 * 评论视图对象 zjk_learning_commont
 *
 * @author ygh
 * @date 2024-11-11
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkLearningCommont.class)
public class ZjkLearningCommontVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @ExcelProperty(value = "评论记录编号")
    private Long id;
    /**
     * 评论
     */
    @ExcelProperty(value = "评论内容")
    private String comment;
    @ExcelProperty(value = "所属帖子")
    private String informationTitle;
    /**
     * 状态
     */
    @ExcelProperty(value = "评论状态",converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = "is_publish")
    private String status;
    /**
     * 评论人
     */
    @ExcelProperty(value = "评论人")
    private String reviewer;


    private Long reviewerId;
    /**
     * 资讯id
     */
    private Long informationId;


    /**
     * 被回复人ID
     */
    private Long replyId;



    /**
     * 评论时间
     */
    @ExcelProperty(value = "评论时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date commentTime;



    /**
     * 备注
     */
    private String remark;

    /**
     * 撤销时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ExcelProperty(value = "撤销时间")
    private Date takedownTime;

    private Long  parentId;

    private String  expertName;

    private String  expertPhotograph;

    private String  deptName;

    private String replyName;

    private String replyPhotograph;
    private String  replyDeptName;

    /**
     * 是否显示删除按钮
     */
    private boolean isDeleted;

    /**
     * 是否显示回复按钮
     */
    private boolean isReply;
    /**
     * 回复
     */
    private List<ZjkLearningCommontVo> commontVoList;
}
