package org.dromara.zjk.learning_world.service;

import org.dromara.zjk.learning_world.domain.excel.ZjkLearningActivityExcel;
import org.dromara.zjk.learning_world.domain.vo.ZjkLearningActivityVo;
import org.dromara.zjk.learning_world.domain.bo.ZjkLearningActivityBo;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.common.mybatis.core.page.PageQuery;

import java.util.Collection;
import java.util.List;

/**
 * 活动管理Service接口
 *
 * @author ygh
 * @date 2024-11-08
 */
public interface IZjkLearningActivityService {

    /**
     * 查询活动管理
     *
     * @param id 主键
     * @return 活动管理
     */
    ZjkLearningActivityVo queryById(Long id);

    /**
     * 分页查询活动管理列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 活动管理分页列表
     */
    TableDataInfo<ZjkLearningActivityVo> queryPageList(ZjkLearningActivityBo bo, PageQuery pageQuery);

    /**
     * 查询符合条件的活动管理列表
     *
     * @param bo 查询条件
     * @return 活动管理列表
     */
    List<ZjkLearningActivityVo> queryList(ZjkLearningActivityBo bo);

    /**
     * 新增活动管理
     *
     * @param bo 活动管理
     * @return 是否新增成功
     */
    Boolean insertByBo(ZjkLearningActivityBo bo);

    /**
     * 修改活动管理
     *
     * @param bo 活动管理
     * @return 是否修改成功
     */
    Boolean updateByBo(ZjkLearningActivityBo bo);

    /**
     * 校验并批量删除活动管理信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);

    List<ZjkLearningActivityExcel> exportList(ZjkLearningActivityBo bo);

    int updateStatus(ZjkLearningActivityBo bo);
}
