package org.dromara.zjk.learning_world.service;

import org.dromara.zjk.learning_world.domain.excel.ZjkLearningCourseExcel;
import org.dromara.zjk.learning_world.domain.vo.ZjkLearningCourseVo;
import org.dromara.zjk.learning_world.domain.bo.ZjkLearningCourseBo;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.common.mybatis.core.page.PageQuery;

import java.util.Collection;
import java.util.List;

/**
 * 课程Service接口
 *
 * @author ygh
 * @date 2024-11-08
 */
public interface IZjkLearningCourseService {

    /**
     * 查询课程
     *
     * @param id 主键
     * @return 课程
     */
    ZjkLearningCourseVo queryById(Long id);

    /**
     * 分页查询课程列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 课程分页列表
     */
    TableDataInfo<ZjkLearningCourseVo> queryPageList(ZjkLearningCourseBo bo, PageQuery pageQuery);

    /**
     * 查询符合条件的课程列表
     *
     * @param bo 查询条件
     * @return 课程列表
     */
    List<ZjkLearningCourseVo> queryList(ZjkLearningCourseBo bo);

    /**
     * 新增课程
     *
     * @param bo 课程
     * @return 是否新增成功
     */
    Boolean insertByBo(ZjkLearningCourseBo bo);

    /**
     * 修改课程
     *
     * @param bo 课程
     * @return 是否修改成功
     */
    Boolean updateByBo(ZjkLearningCourseBo bo);

    /**
     * 校验并批量删除课程信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);

    List<ZjkLearningCourseExcel> exportList(ZjkLearningCourseBo bo);

    int updateStatus(ZjkLearningCourseBo bo);
}
