package org.dromara.zjk.mapper;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import jakarta.validation.constraints.NotBlank;
import org.apache.ibatis.annotations.Param;
import org.dromara.common.mybatis.annotation.DataColumn;
import org.dromara.common.mybatis.annotation.DataPermission;
import org.dromara.common.mybatis.core.mapper.BaseMapperPlus;
import org.dromara.zjk.domain.ProductCountReport;
import org.dromara.zjk.domain.ZjkProduct;
import org.dromara.zjk.domain.bo.ZjkProductBo;
import org.dromara.zjk.domain.dto.ProjectSummaryStatistics;
import org.dromara.zjk.domain.vo.*;

import java.util.List;
import java.util.Set;

/**
 * 项目管理Mapper接口
 *
 * @author ygh
 * @date 2024-11-01
 */
public interface ZjkProductMapper extends BaseMapperPlus<ZjkProduct, ZjkProductVo> {
    @DataPermission({
        @DataColumn(key = "xmUserName", value = "zp.user_id"),
        @DataColumn(key = "deptName", value = "zp.create_dept")
    })
    Page<ZjkProductVo> getProduct(Page<ZjkProductVo> build);

    ItemVO getItemId(Long productId, Long reviewId);

    List<ZjkReviewProductVo> getProductReview(@Param("productId") Long productId);

    @DataPermission({
        @DataColumn(key = "xmUserName", value = "zp.user_id"),
        @DataColumn(key = "deptName", value = "zp.create_dept"),
    })
    IPage<ProductPanoramaVo> productPanorama(@Param("bo") ProductPanoramaVo vo,Page<ZjkProduct> build);

    List<ProductCountReport> getProductTypeCountReport();
    IPage<ZjkProductVo> selectProductReview(Page<ZjkProduct> build, ZjkProductBo bo);

    List<ProjectSummaryStatisticsVo> getReviewStageSummary();

    ProjectSummaryStatistics projectSummaryStatistics();

    @DataPermission({
        @DataColumn(key = "xmUserName", value = "user_id"),
        @DataColumn(key = "deptName", value = "create_dept"),
    })
    Page<ZjkProductVo> selectProdoctPage(Page<ZjkProduct> build, ZjkProductBo bo);
    List<ZjkProductVo> selectProdoctForApi(@Param("bo") ZjkProductBo bo);

    @DataPermission({
        @DataColumn(key = "xmUserName", value = "zp.user_id"),
        @DataColumn(key = "deptName", value = "zp.create_dept"),
    })
    Set<ProductPanoramaDeptVo> productPanoramaDept();

    void updateProductByApproval(Long id, Integer approvalStatus, String approvalReason);

    Page<ProductPanoramaVo> getProductList(Page<Object> build,@Param("bo") ProductPanoramaVo bo);
}
