package org.dromara.zjk.service;


import jakarta.servlet.http.HttpServletResponse;
import org.dromara.common.core.domain.R;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.common.mybatis.core.page.PageQuery;
import org.dromara.zjk.domain.bo.ZjkInvoiceBo;
import org.dromara.zjk.domain.vo.CheckSupportVo;
import org.dromara.zjk.domain.vo.InvoiceStatisticsVO;
import org.dromara.zjk.domain.vo.ZjkInvoiceVo;
import org.springframework.web.multipart.MultipartFile;

import java.util.Collection;
import java.util.List;

/**
 * 发票Service接口
 *
 * @author mzx
 * @date 2024-12-09
 */
public interface IZjkInvoiceService {

    /**
     * 查询发票
     *
     * @param id 主键
     * @return 发票
     */
    ZjkInvoiceVo queryById(Long id);

    /**
     * 分页查询发票列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 发票分页列表
     */
    TableDataInfo<ZjkInvoiceVo> queryPageList(ZjkInvoiceBo bo, PageQuery pageQuery);

    /**
     * 查询符合条件的发票列表
     *
     * @param bo 查询条件
     * @return 发票列表
     */
    List<ZjkInvoiceVo> queryList(ZjkInvoiceBo bo);

    /**
     * 新增发票
     *
     * @param bo 发票
     * @return 是否新增成功
     */
    Boolean insertByBo(ZjkInvoiceBo bo);

    /**
     * 修改发票
     *
     * @param bo 发票
     * @return 是否修改成功
     */
    Boolean updateByBo(ZjkInvoiceBo bo);

    /**
     * 校验并批量删除发票信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);

    /**
     * 导入信息excel
     *
     * @param file
     * @return
     */
    R<Void> imports(MultipartFile file);

    /**
     * ，包括发票的数量、金额、开票单位等,
     * @return
     */
    InvoiceStatisticsVO statistics();

    Boolean check(Long moneyId);

    CheckSupportVo getInvByProductInfo(String productId, String reviewSn, String expertId);

    void downloadExcelTem(HttpServletResponse response);
}
