package org.dromara.zjk.service;

import org.dromara.zjk.domain.ZjkProductSummarizeLog;
import org.dromara.zjk.domain.vo.AuditVo;
import org.dromara.zjk.domain.vo.ZjkProductSummarizeLogVo;
import org.dromara.zjk.domain.bo.ZjkProductSummarizeLogBo;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.common.mybatis.core.page.PageQuery;

import java.util.Collection;
import java.util.List;

/**
 * 总结日志表Service接口
 *
 * @author ygh
 * @date 2024-11-04
 */
public interface IZjkProductSummarizeLogService {

    /**
     * 查询总结日志表
     *
     * @param id 主键
     * @return 总结日志表
     */
    ZjkProductSummarizeLogVo queryById(Long id);

    /**
     * 分页查询总结日志表列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 总结日志表分页列表
     */
    TableDataInfo<ZjkProductSummarizeLogVo> queryPageList(ZjkProductSummarizeLogBo bo, PageQuery pageQuery);

    /**
     * 查询符合条件的总结日志表列表
     *
     * @param bo 查询条件
     * @return 总结日志表列表
     */
    List<ZjkProductSummarizeLogVo> queryList(ZjkProductSummarizeLogBo bo);

    /**
     * 新增总结日志表
     *
     * @param bo 总结日志表
     * @return 是否新增成功
     */
    Boolean insertByBo(ZjkProductSummarizeLogBo bo);

    /**
     * 修改总结日志表
     *
     * @param bo 总结日志表
     * @return 是否修改成功
     */
    Boolean updateByBo(ZjkProductSummarizeLogBo bo);

    /**
     * 校验并批量删除总结日志表信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);

    int audit(AuditVo bo);
}
