package org.dromara.zjk.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.dromara.zjk.domain.ZjkPointReward;
import org.dromara.zjk.enums.OperateCodeEnum;
import org.dromara.zjk.service.ZjkPointRewardService;
import org.dromara.zjk.mapper.ZjkPointRewardMapper;
import org.springframework.stereotype.Service;
import org.stringtemplate.v4.ST;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * @author EDY
 * @description 针对表【zjk_point_reward(积分奖励)】的数据库操作Service实现
 * @createDate 2024-11-06 16:29:59
 */
@Service
public class ZjkPointRewardServiceImpl extends ServiceImpl<ZjkPointRewardMapper, ZjkPointReward>
    implements ZjkPointRewardService {
    @Resource
    private ZjkPointRewardMapper zjkPointRewardMapper;

    @Override
    public List<String> getRewardTitle(Long expertId, BigDecimal points) {
        List<ZjkPointReward> reward = zjkPointRewardMapper.getAbleReward();
        ArrayList<String> strings = new ArrayList<>();
        reward.stream().forEach(item -> {
            String result = "";
            Integer effectFlag = item.getEffectFlag();
            if (OperateCodeEnum.DAYU.getCode().equals(effectFlag) && points.compareTo(item.getEffectStandard()) >0) {
                strings.add(item.getRewardName());
            }else if(OperateCodeEnum.XAIOYU.getCode().equals(effectFlag)&& points.compareTo(item.getEffectStandard()) < 0){
                strings.add(item.getRewardName());
            }else if (OperateCodeEnum.EQUES.getCode().equals(effectFlag)&& points.compareTo(item.getEffectStandard()) == 0){
                strings.add(item.getRewardName());
            }
        });
        return strings;
    }

    public static void main(String[] args) {
        Integer a =1;
        Integer b=1;
        BigDecimal c = new BigDecimal(1);
        BigDecimal d = new BigDecimal(1);
        System.out.print(a.equals(b));
    }
}




