package org.dromara.zjk.statement.domain;

import org.dromara.common.tenant.core.TenantEntity;
import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.math.BigDecimal;
import org.dromara.zjk.annotation.PropertyMsg;
import java.io.Serial;

/**
 * 报表分析对象 zjk_money_analyse_statement
 *
 * @author ygh
 * @date 2024-12-16
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("zjk_money_analyse_statement")
public class ZjkMoneyAnalyseStatement extends TenantEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @PropertyMsg(propertyName = "id")
    private Long id;

    /**
     * 专家类型;专家类型
     */
    @PropertyMsg(propertyName = "expert_type")
    private String expertType;

    /**
     * 总费用;总费用
     */
    @PropertyMsg(propertyName = "sum_fee")
    private BigDecimal sumFee;

    /**
     * 占比;占比
     */
    @PropertyMsg(propertyName = "proportion")
    private BigDecimal proportion;

    /**
     * 变化趋势;变化趋势
     */
    @PropertyMsg(propertyName = "tendency")
    private BigDecimal tendency;

    /**
     * 状态
     */
    @PropertyMsg(propertyName = "status")
    private String status;

    /**
     * 备注
     */
    @PropertyMsg(propertyName = "remark")
    private String remark;

    /**
     * 报表id
     */
    @PropertyMsg(propertyName = "statement_id")
    private Long statementId;

    /**
     * 是否删除
     */
    @TableLogic
    @PropertyMsg(propertyName = "del_flag")
    private Long delFlag;


}
