package org.dromara.zjk.zwy.utils;



import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.dromara.zjk.zwy.client.DecryptClient;
import org.dromara.zjk.zwy.client.EncryptClient;

import org.springframework.stereotype.Component;

/**
 * 简单字符串加解密工具类
 */
@Slf4j
@Component
@RequiredArgsConstructor
public class StringCryptoUtil {

    private final DecryptClient decryptClient;
    private final EncryptClient encryptClient;


    /**
     * 解密单个字符串，空串或null原样返回
     */
    public String decryptField(String str) {
        if (str == null || str.isBlank()) {
            return str;
        }
        try {
            return decryptClient.decrypt(str);
        } catch (Exception e) {
            log.error("字符串解密失败，密文: {}", str, e);
            throw new RuntimeException("字符串解密失败", e);
        }
    }

    /**
     * 加密单个字符串，空串或null原样返回
     */
    public String encryptField(String str) {
        if (str == null || str.isBlank()) {
            return str;
        }
        try {
            return encryptClient.encrypt(str);
        } catch (Exception e) {
            log.error("字符串加密失败，明文: {}", str, e);
            throw new RuntimeException("字符串加密失败", e);
        }
    }
}
