/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser;

import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.network.trace.component.OfficialComponent;
import org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser.AbstractURLParser;
import org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser.URLLocation;
import org.apache.skywalking.apm.plugin.jdbc.trace.ConnectionInfo;

public class MssqlJtdsURLParser
extends AbstractURLParser {
    private static final int DEFAULT_PORT = 1433;
    private String dbType = "Mssql";
    private OfficialComponent component = ComponentsDefine.MSSQL_JDBC_DRIVER;
    private static ILog LOGGER = LogManager.getLogger(MssqlJtdsURLParser.class);

    public MssqlJtdsURLParser(String url) {
        super(url);
    }

    public MssqlJtdsURLParser(String url, String dbType, OfficialComponent component) {
        super(url);
        this.dbType = dbType;
        this.component = component;
    }

    @Override
    protected URLLocation fetchDatabaseHostsIndexRange() {
        int hostLabelStartIndex = this.url.indexOf("//");
        int hostLabelEndIndex = this.url.indexOf(";", hostLabelStartIndex + 2);
        if (hostLabelEndIndex == -1) {
            hostLabelEndIndex = this.url.indexOf("/", hostLabelStartIndex + 2);
        }
        return new URLLocation(hostLabelStartIndex + 2, hostLabelEndIndex);
    }

    protected String fetchDatabaseNameFromURL(int startSize) {
        URLLocation hostsLocation = this.fetchDatabaseNameIndexRange(startSize);
        if (hostsLocation == null) {
            return "";
        }
        return this.url.substring(hostsLocation.startIndex(), hostsLocation.endIndex());
    }

    protected URLLocation fetchDatabaseNameIndexRange(int startSize) {
        int databaseStartTag = this.url.indexOf("/", startSize);
        if (databaseStartTag == -1) {
            return null;
        }
        int databaseEndTag = this.url.indexOf(";", databaseStartTag);
        if (databaseEndTag == -1) {
            databaseEndTag = this.url.length();
        }
        return new URLLocation(databaseStartTag + 1, databaseEndTag);
    }

    @Override
    protected URLLocation fetchDatabaseNameIndexRange() {
        int databaseStartTag = this.url.lastIndexOf("/");
        int databaseEndTag = this.url.indexOf(";", databaseStartTag);
        if (databaseEndTag == -1) {
            databaseEndTag = this.url.length();
        }
        return new URLLocation(databaseStartTag + 1, databaseEndTag);
    }

    @Override
    public ConnectionInfo parse() {
        try {
            URLLocation location = this.fetchDatabaseHostsIndexRange();
            String hosts = this.url.substring(location.startIndex(), location.endIndex());
            String[] hostSegment = hosts.split(",");
            if (hostSegment.length > 1) {
                StringBuilder sb = new StringBuilder();
                for (String host : hostSegment) {
                    if (host.split(":").length == 1) {
                        sb.append(host).append(":").append(1433).append(",");
                        continue;
                    }
                    sb.append(host).append(",");
                }
                return new ConnectionInfo(this.component, this.dbType, sb.substring(0, sb.length() - 1), this.fetchDatabaseNameFromURL());
            }
            String[] hostAndPort = hostSegment[0].split(":");
            if (hostAndPort.length != 1) {
                return new ConnectionInfo(this.component, this.dbType, hostAndPort[0], Integer.valueOf(hostAndPort[1]), this.fetchDatabaseNameFromURL(location.endIndex()));
            }
            return new ConnectionInfo(this.component, this.dbType, hostAndPort[0], 1433, this.fetchDatabaseNameFromURL(location.endIndex()));
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e, "parse mssql connection info error, url:{}", new Object[]{this.url});
            return new ConnectionInfo(this.component, this.dbType, this.url, "UNKNOWN");
        }
    }
}

