/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.autoconfigure.web.embedded;

import com.tongweb.commons.license.DynamicLoadingListener;
import com.tongweb.commons.license.LicenseProviderFacade;
import com.tongweb.connector.AbstractProtocol;
import com.tongweb.connector.ProtocolHandler;
import com.tongweb.connector.UpgradeProtocol;
import com.tongweb.connector.http11.AbstractHttp11Protocol;
import com.tongweb.connector.http11.Http11NioProtocol;
import com.tongweb.connector.http2.Http2Protocol;
import com.tongweb.container.LifecycleListener;
import com.tongweb.container.Valve;
import com.tongweb.container.core.StandardHost;
import com.tongweb.container.security.SecurityListener;
import com.tongweb.container.valves.AccessLogValve;
import com.tongweb.container.valves.ErrorReportValve;
import com.tongweb.container.valves.ExtendedAccessLogValve;
import com.tongweb.container.valves.JsonErrorReportValve;
import com.tongweb.container.valves.RemoteIpValve;
import com.tongweb.container.valves.SemaphoreValve;
import com.tongweb.container.valves.StuckThreadDetectionValve;
import com.tongweb.springboot.autoconfigure.web.ServerProperties;
import com.tongweb.springboot.autoconfigure.web.TongWebConfig;
import com.tongweb.springboot.autoconfigure.web.properties.AuditLog;
import com.tongweb.springboot.autoconfigure.web.properties.RemoteFilter;
import com.tongweb.springboot.autoconfigure.web.properties.RemoteFilterConfigBean;
import com.tongweb.springboot.autoconfigure.web.properties.SocketConfigBean;
import com.tongweb.springboot.web.embedded.tongweb.ConfigurableTongWebWebServerFactory;
import com.tongweb.springboot.web.embedded.tongweb.TongWebServletWebServerFactory;
import java.io.File;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;
import org.springframework.util.unit.DataSize;

public class TongWebWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<ConfigurableTongWebWebServerFactory>,
Ordered {
    private final Environment environment;
    private final ServerProperties serverProperties;
    private static final Log logger = LogFactory.getLog(TongWebWebServerFactoryCustomizer.class);

    public TongWebWebServerFactoryCustomizer(Environment environment, ServerProperties serverProperties) {
        this.environment = environment;
        this.serverProperties = serverProperties;
    }

    private static boolean isIncludeStacktraceNever(ErrorProperties error) {
        try {
            Field includeStacktrace = error.getClass().getDeclaredField("includeStacktrace");
            includeStacktrace.setAccessible(true);
            Object value = includeStacktrace.get(error);
            return value.toString().equals("NEVER");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int getOrder() {
        return 0;
    }

    public void customize(ConfigurableTongWebWebServerFactory factory) {
        ServerProperties properties = this.serverProperties;
        TongWebConfig tongWebConfig = properties.getTongweb();
        PropertyMapper propertyMapper = PropertyMapper.get();
        TongWebServletWebServerFactory tongWebServletWebServerFactory = (TongWebServletWebServerFactory)factory;
        propertyMapper.from(tongWebConfig::getNotAllowHttpMethods).to(tongWebServletWebServerFactory::setNotAllowHttpMethods);
        propertyMapper.from(tongWebConfig::getBasedir).whenNonNull().to(factory::setBaseDirectory);
        propertyMapper.from(tongWebConfig::getBackgroundProcessorDelay).whenNonNull().as(Duration::getSeconds).as(Long::intValue).to(factory::setBackgroundProcessorDelay);
        this.customizeRemoteIpValve(factory);
        propertyMapper.from(tongWebConfig::getMaxThreads).when(this::isPositive).to(maxThreads -> this.customizeMaxThreads(factory, tongWebConfig.getMaxThreads()));
        propertyMapper.from(tongWebConfig::getMinSpareThreads).when(this::isPositive).to(minSpareThreads -> this.customizeMinThreads(factory, (int)minSpareThreads));
        propertyMapper.from(this.serverProperties::getMaxHttpHeaderSize).whenNonNull().when(this::isPositive).to(maxHttpHeaderSize -> this.customizeMaxHttpHeaderSize(factory, (int)maxHttpHeaderSize));
        propertyMapper.from(tongWebConfig::getMaxConnections).when(this::isPositive).to(maxConnections -> this.customizeMaxConnections(tongWebServletWebServerFactory, (int)maxConnections));
        propertyMapper.from((Object)this.serverProperties.getTongweb().getMaxSavePostSize()).whenNonNull().as(DataSize::parse).asInt(DataSize::toBytes).when(this::isPositive).to(maxSavePostSize -> this.customizeMaxSavePostSize(tongWebServletWebServerFactory, (int)maxSavePostSize));
        propertyMapper.from(tongWebConfig::getMaxHttpPostSize).as(DataSize::parse).asInt(DataSize::toBytes).when(maxHttpPostSize -> maxHttpPostSize != 0).to(maxHttpPostSize -> this.customizeMaxHttpPostSize(tongWebServletWebServerFactory, (int)maxHttpPostSize));
        propertyMapper.from(tongWebConfig::getMaxParameterCount).when(maxParameterCount -> maxParameterCount != 0).to(maxParameterCount -> this.customizeMaxParameterCount(tongWebServletWebServerFactory, (int)maxParameterCount));
        propertyMapper.from(tongWebConfig::getMaxSwallowSize).whenNonNull().as(DataSize::parse).asInt(DataSize::toBytes).to(maxSwallowSize -> this.customizeMaxSwallowSize(tongWebServletWebServerFactory, (int)maxSwallowSize));
        propertyMapper.from(tongWebConfig::getMaxTrailerSize).whenNonNull().to(maxTrailerSize -> this.customizeMaxTrailerSize(factory, (int)maxTrailerSize));
        propertyMapper.from(tongWebConfig::getMaxHttpFormPostSize).when(maxHttpFormPostSize -> maxHttpFormPostSize != 0).to(maxHttpFormPostSize -> this.customizeMaxHttpFormPostSize(factory, (int)maxHttpFormPostSize));
        propertyMapper.from(tongWebConfig::getUriEncoding).whenNonNull().to(factory::setUriEncoding);
        propertyMapper.from(tongWebConfig::getConnectionTimeout).whenNonNull().to(connectionTimeout -> this.customizeConnectionTimeout(factory, (Duration)connectionTimeout));
        propertyMapper.from(tongWebConfig::getAcceptCount).when(this::isPositive).to(acceptCount -> this.customizeAcceptCount(factory, (int)acceptCount));
        propertyMapper.from(tongWebConfig::getProcessorCache).to(processorCache -> this.customizeProcessorCache(factory, (int)processorCache));
        propertyMapper.from(tongWebConfig::getKeepAliveTimeout).whenNonNull().to(keepAliveTimeout -> this.customizeKeepAliveTimeout(factory, (Duration)keepAliveTimeout));
        propertyMapper.from(tongWebConfig::getMaxKeepAliveRequests).to(maxKeepAliveRequests -> this.customizeMaxKeepAliveRequests(factory, (int)maxKeepAliveRequests));
        propertyMapper.from(tongWebConfig::getRelaxedPathChars).as(this::joinCharacters).whenHasText().to(relaxedChars -> this.customizeRelaxedPathChars(factory, (String)relaxedChars));
        propertyMapper.from(tongWebConfig::getRelaxedQueryChars).as(this::joinCharacters).whenHasText().to(relaxedChars -> this.customizeRelaxedQueryChars(factory, (String)relaxedChars));
        propertyMapper.from(tongWebConfig::getAccesslog).when(TongWebConfig.Accesslog::isEnabled).to(enabled -> this.customizeAccessLog(tongWebServletWebServerFactory, (TongWebConfig.Accesslog)enabled));
        propertyMapper.from(tongWebConfig::getAsyncTimeout).whenNonNull().to(asyncTimeout -> this.customizeAsyncTimeout(tongWebServletWebServerFactory, (Duration)asyncTimeout));
        propertyMapper.from(tongWebConfig::getAuditLog).when(AuditLog::getEnable).to(auditLog -> this.customizeAuditLog(tongWebServletWebServerFactory, (AuditLog)auditLog));
        propertyMapper.from(tongWebConfig::getConnectionLinger).whenNonNull().to(connectionLinger -> this.customizeConnectionLinger(tongWebServletWebServerFactory, (Duration)connectionLinger));
        propertyMapper.from(tongWebConfig::getConnectionUploadTimeout).when(duration -> tongWebConfig.getDisableUploadTimeout() == false).when(Objects::nonNull).to(connectionUploadTimeout -> this.customizeConnectionUploadTimeout(tongWebServletWebServerFactory, (Duration)connectionUploadTimeout));
        propertyMapper.from(tongWebConfig::getDiscardFacades).whenNonNull().to(discardFacades -> this.customizeDiscardFacades(tongWebServletWebServerFactory, (Boolean)discardFacades));
        propertyMapper.from((Object)tongWebConfig.getDocBasePath()).whenNonNull().to(docBasePath -> this.customizeDocBase(tongWebServletWebServerFactory, (String)docBasePath));
        propertyMapper.from(tongWebConfig::getEnableLookups).to(enableLookups -> this.customizeEnableLookups(tongWebServletWebServerFactory, (boolean)enableLookups));
        propertyMapper.from(tongWebConfig::getEncodedSolidusHandling).whenNonNull().to(encodedSolidusHandling -> this.customizeEncodedSolidusHandling(tongWebServletWebServerFactory, (String)encodedSolidusHandling));
        propertyMapper.from(tongWebConfig::getMaxCookieCount).whenNonNull().to(maxCookieCount -> this.customizeMaxCookieCount(tongWebServletWebServerFactory, (Integer)maxCookieCount));
        propertyMapper.from(tongWebConfig::getRestrictedUserAgents).whenNonNull().to(restrictedUserAgents -> this.customizeRestrictedUserAgents(tongWebServletWebServerFactory, (String)restrictedUserAgents));
        propertyMapper.from(tongWebConfig::getTcpNoDelay).whenNonNull().to(tcpNoDelay -> this.customizeTcpNoDelay(tongWebServletWebServerFactory, (Boolean)tcpNoDelay));
        propertyMapper.from(tongWebConfig::getThrowOnFailure).whenNonNull().to(throwOnFailure -> this.customizeThrowOnFailure(tongWebServletWebServerFactory, (Boolean)throwOnFailure));
        propertyMapper.from(tongWebConfig::getUseKeepAliveResponseHeader).whenNonNull().to(useKeepAliveResponseHeader -> this.customizeUseKeepAliveResponseHeader(tongWebServletWebServerFactory, (Boolean)useKeepAliveResponseHeader));
        propertyMapper.from((Object)tongWebConfig.getFilter().getRemote()).when(RemoteFilter::isEnabled).to(remoteFilter -> this.customizeRemoteFilter(tongWebServletWebServerFactory, (RemoteFilter)remoteFilter));
        propertyMapper.from(tongWebConfig::getSelectorTimeout).whenNonNull().to(selectorTimeout -> this.customizeSelectorTimeout(tongWebServletWebServerFactory, (Long)selectorTimeout));
        propertyMapper.from(tongWebConfig::getSemaphore).when(TongWebConfig.SemaphoreConf::isEnabled).to(enabled -> this.customizeSemaphore(tongWebServletWebServerFactory));
        propertyMapper.from(tongWebConfig::getSocket).to(socket -> this.customizeSocket(tongWebServletWebServerFactory, (SocketConfigBean)socket));
        propertyMapper.from(tongWebConfig::getStuckThreadDetection).whenNonNull().to(stuckThreadDetection -> this.customizeStuckThreadDetectionValue(tongWebServletWebServerFactory, (TongWebConfig.StuckThreadDetectionConf)stuckThreadDetection));
        this.customizeStaticResources(factory);
        this.customizeErrorReportValve(tongWebServletWebServerFactory);
        this.customizeSecurityListener(tongWebServletWebServerFactory);
        factory.setServerProperties(properties);
    }

    private void customizeStuckThreadDetectionValue(TongWebServletWebServerFactory factory, TongWebConfig.StuckThreadDetectionConf stuckThreadDetection) {
        if (stuckThreadDetection.getThreshold() != 0) {
            StuckThreadDetectionValve value = new StuckThreadDetectionValve();
            value.setThreshold(stuckThreadDetection.getThreshold());
            value.setInterruptThreadThreshold(stuckThreadDetection.getInterruptThreadThreshold());
            factory.addEngineValves(new Valve[]{value});
        }
    }

    private void customizeSocket(TongWebServletWebServerFactory factory, SocketConfigBean socket) {
        factory.addConnectorCustomizers(connector -> {
            if (socket.getDirectBuffer() != null) {
                connector.setProperty("socket.directBuffer", socket.getDirectBuffer().toString());
            } else {
                connector.setProperty("socket.directBuffer", "true");
            }
            if (socket.getDirectSslBuffer() != null) {
                connector.setProperty("socket.directSslBuffer", socket.getDirectSslBuffer().toString());
            }
            if (socket.getRxBufSize() != null) {
                connector.setProperty("socket.rxBufSize", socket.getRxBufSize().toString());
            }
            if (socket.getTxBufSize() != null) {
                connector.setProperty("socket.txBufSize", socket.getTxBufSize().toString());
            }
            if (socket.getAppReadBufSize() != null) {
                connector.setProperty("socket.appReadBufSize", socket.getAppReadBufSize().toString());
            }
            if (socket.getAppWriteBufSize() != null) {
                connector.setProperty("socket.appWriteBufSize", socket.getAppWriteBufSize().toString());
            }
            if (socket.getBufferPool() != null) {
                connector.setProperty("socket.bufferPool", socket.getBufferPool().toString());
            }
            if (socket.getBufferPoolSize() != null) {
                connector.setProperty("socket.bufferPoolSize", socket.getBufferPoolSize().toString());
            }
            if (socket.getProcessorCache() != null) {
                connector.setProperty("socket.processorCache", socket.getProcessorCache().toString());
            } else {
                connector.setProperty("socket.processorCache", "15000");
            }
            if (socket.getKeyCache() != null) {
                connector.setProperty("socket.keyCache", socket.getKeyCache().toString());
            } else {
                connector.setProperty("socket.keyCache", "15000");
            }
            if (socket.getEventCache() != null) {
                connector.setProperty("socket.eventCache", socket.getEventCache().toString());
            } else {
                connector.setProperty("socket.eventCache", "15000");
            }
            if (socket.getTcpNoDelay() != null) {
                connector.setProperty("socket.tcpNoDelay", socket.getTcpNoDelay().toString());
            }
            if (socket.getSoKeepAlive() != null) {
                connector.setProperty("socket.soKeepAlive", socket.getSoKeepAlive().toString());
            }
            if (socket.getOoBInline() != null) {
                connector.setProperty("socket.ooBInline", socket.getOoBInline().toString());
            }
            if (socket.getSoReuseAddress() != null) {
                connector.setProperty("socket.soReuseAddress", socket.getSoReuseAddress().toString());
            }
            if (socket.getSoLingerOn() != null) {
                connector.setProperty("socket.soLingerOn", socket.getSoLingerOn().toString());
            }
            if (socket.getSoLingerTime() != null) {
                connector.setProperty("socket.soLingerTime", socket.getSoLingerTime().toString());
            }
            if (socket.getSoTimeout() != null) {
                connector.setProperty("socket.soTimeout", socket.getSoTimeout().toString());
            }
            if (socket.getPerformanceConnectionTime() != null) {
                connector.setProperty("socket.performanceConnectionTime", socket.getPerformanceConnectionTime().toString());
            } else {
                connector.setProperty("socket.performanceConnectionTime", "0");
            }
            if (socket.getPerformanceLatency() != null) {
                connector.setProperty("socket.performanceLatency", socket.getPerformanceLatency().toString());
            } else {
                connector.setProperty("socket.performanceLatency", "1");
            }
            if (socket.getPerformanceBandwidth() != null) {
                connector.setProperty("socket.performanceBandwidth", socket.getPerformanceBandwidth().toString());
            } else {
                connector.setProperty("socket.performanceBandwidth", "2");
            }
            if (socket.getUnlockTimeout() != null) {
                connector.setProperty("socket.unlockTimeout", socket.getUnlockTimeout().toString());
            }
        });
    }

    private void customizeSemaphore(TongWebServletWebServerFactory factory) {
        SemaphoreValve valve = new SemaphoreValve();
        TongWebConfig tongweb = this.serverProperties.getTongweb();
        PropertyMapper map = PropertyMapper.get();
        TongWebConfig.SemaphoreConf semaphoreConfig = tongweb.getSemaphore();
        map.from((Object)semaphoreConfig.getConcurrency()).to(arg_0 -> ((SemaphoreValve)valve).setConcurrency(arg_0));
        map.from((Object)semaphoreConfig.isFairness()).to(arg_0 -> ((SemaphoreValve)valve).setFairness(arg_0));
        map.from((Object)semaphoreConfig.isBlock()).to(arg_0 -> ((SemaphoreValve)valve).setBlock(arg_0));
        map.from((Object)semaphoreConfig.isInterruptible()).to(arg_0 -> ((SemaphoreValve)valve).setInterruptible(arg_0));
        factory.setSemaphore((Valve)valve);
    }

    private void customizeSelectorTimeout(TongWebServletWebServerFactory factory, Long selectorTimeout) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof Http11NioProtocol) {
                Http11NioProtocol protocol = (Http11NioProtocol)handler;
                protocol.setSelectorTimeout(selectorTimeout.longValue());
            }
        });
    }

    private void customizeSecurityListener(TongWebServletWebServerFactory factory) {
        boolean securityEnabled = this.serverProperties.getTongweb().getSecurityListener().isEnabled();
        boolean removeRootUser = this.serverProperties.getTongweb().getSecurityListener().isRemoveRootUser();
        String minimumUmask = this.serverProperties.getTongweb().getSecurityListener().getMinimumUmask();
        String checkedOsUsers = this.serverProperties.getTongweb().getSecurityListener().getCheckedOsUsers();
        if (securityEnabled) {
            SecurityListener securityListener = new SecurityListener();
            if (!StringUtils.isEmpty((Object)minimumUmask)) {
                securityListener.setMinimumUmask(minimumUmask);
            }
            if (removeRootUser) {
                securityListener.setCheckedOsUsers("");
            }
            if (!StringUtils.isEmpty((Object)checkedOsUsers)) {
                securityListener.setCheckedOsUsers(checkedOsUsers);
            }
            factory.addServerLifecycleListeners(new LifecycleListener[]{securityListener});
        }
    }

    private void customizeRemoteFilter(TongWebServletWebServerFactory factory, RemoteFilter remoteFilter) {
        PropertyMapper map = PropertyMapper.get();
        RemoteFilterConfigBean rf = new RemoteFilterConfigBean();
        map.from((Object)remoteFilter.getAllowAddr()).whenNonNull().to(rf::setAllowAddr);
        map.from((Object)remoteFilter.getAllowHost()).whenNonNull().to(rf::setAllowHost);
        map.from((Object)remoteFilter.getDenyAddr()).whenNonNull().to(rf::setDenyAddr);
        map.from((Object)remoteFilter.getDenyStatus()).whenNonNull().to(rf::setDenyStatus);
        map.from((Object)remoteFilter.getDenyHost()).whenNonNull().to(rf::setDenyHost);
        factory.setRemoteFilter(rf);
    }

    private void customizeErrorReportValve(TongWebServletWebServerFactory factory) {
        block9: {
            boolean jsonErrorReportValveEnabled = this.serverProperties.getTongweb().getJsonErrorReportValve().isEnabled();
            if (jsonErrorReportValveEnabled) {
                String errorValveClassName = "com.tongweb.container.valves.JsonErrorReportValve";
                JsonErrorReportValve valve = new JsonErrorReportValve();
                factory.addContextCustomizers(context -> {
                    StandardHost host = (StandardHost)context.getParent();
                    host.setErrorReportValveClass(errorValveClassName);
                    host.getPipeline().addValve((Valve)valve);
                });
            } else if (this.serverProperties.getTongweb().getErrorReportValve().isEnabled()) {
                boolean errorReportValveShowReport = this.serverProperties.getTongweb().getErrorReportValve().isShowReport();
                boolean errorReportValveShowServerInfo = this.serverProperties.getTongweb().getErrorReportValve().isShowServerInfo();
                this.generateErrorReportValve(factory, errorReportValveShowReport, errorReportValveShowServerInfo);
            } else if (!StringUtils.isEmpty((Object)this.serverProperties.getTongweb().getCustomizedErrorReportValve().getType())) {
                String customizedErrorValveType = this.serverProperties.getTongweb().getCustomizedErrorReportValve().getType();
                try {
                    Object customizedErrorValveObj = Class.forName(customizedErrorValveType).getConstructor(new Class[0]).newInstance(new Object[0]);
                    if (customizedErrorValveObj instanceof ErrorReportValve) {
                        ErrorReportValve customizedErrorValve = (ErrorReportValve)customizedErrorValveObj;
                        factory.addContextCustomizers(context -> {
                            StandardHost host = (StandardHost)context.getParent();
                            host.getPipeline().addValve((Valve)customizedErrorValve);
                        });
                        break block9;
                    }
                    logger.warn((Object)("customize valve class " + customizedErrorValveType + " is invalid , customized errorValve failed."));
                }
                catch (Throwable e) {
                    logger.warn((Object)("class " + customizedErrorValveType + " not exist. customized errorValve failed."), e);
                }
            } else {
                this.generateErrorReportValve(factory, true, false);
            }
        }
    }

    private void generateErrorReportValve(TongWebServletWebServerFactory factory, boolean showReport, boolean showServerInfo) {
        ErrorReportValve valve = new ErrorReportValve();
        valve.setShowReport(showReport);
        valve.setShowServerInfo(showServerInfo);
        factory.addContextCustomizers(context -> {
            StandardHost host = (StandardHost)context.getParent();
            host.setErrorReportValveClass(valve.getClass().getCanonicalName());
            host.getPipeline().addValve((Valve)valve);
        });
    }

    private void customizeTcpNoDelay(TongWebServletWebServerFactory factory, Boolean tcpNoDelay) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractProtocol) {
                AbstractProtocol protocol = (AbstractProtocol)handler;
                protocol.setTcpNoDelay(tcpNoDelay.booleanValue());
            }
        });
    }

    private void customizeThrowOnFailure(TongWebServletWebServerFactory factory, Boolean throwOnFailure) {
        factory.addConnectorCustomizers(connector -> connector.setThrowOnFailure(throwOnFailure.booleanValue()));
    }

    private void customizeUseKeepAliveResponseHeader(TongWebServletWebServerFactory factory, Boolean useKeepAliveResponseHeader) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractHttp11Protocol) {
                AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
                protocol.setUseKeepAliveResponseHeader(useKeepAliveResponseHeader.booleanValue());
            }
        });
    }

    private void customizeRestrictedUserAgents(TongWebServletWebServerFactory factory, String restrictedUserAgents) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractHttp11Protocol) {
                AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
                protocol.setRestrictedUserAgents(restrictedUserAgents);
            }
        });
    }

    private void customizeRejectIllegalHeader(TongWebServletWebServerFactory factory, Boolean rejectIllegalHeader) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractHttp11Protocol) {
                AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
                protocol.setRejectIllegalHeader(rejectIllegalHeader.booleanValue());
            }
        });
    }

    private void customizeEncodedSolidusHandling(TongWebServletWebServerFactory factory, String encodedSolidusHandling) {
        factory.addConnectorCustomizers(connector -> connector.setEncodedSolidusHandling(encodedSolidusHandling));
    }

    private void customizeMaxCookieCount(TongWebServletWebServerFactory factory, Integer maxCookieCount) {
        factory.addConnectorCustomizers(connector -> connector.setMaxCookieCount(maxCookieCount.intValue()));
    }

    private void customizeEnableLookups(TongWebServletWebServerFactory factory, boolean enableLookups) {
        factory.addConnectorCustomizers(connector -> connector.setEnableLookups(enableLookups));
    }

    private void customizeDocBase(TongWebServletWebServerFactory factory, String docBasePath) {
        factory.setDocumentRoot(new File(docBasePath));
        factory.addContextCustomizers(context -> context.setDocBase(docBasePath));
    }

    private void customizeDiscardFacades(TongWebServletWebServerFactory factory, Boolean discardFacades) {
        factory.addConnectorCustomizers(connector -> connector.setDiscardFacades(discardFacades.booleanValue()));
    }

    private void customizeConnectionUploadTimeout(TongWebServletWebServerFactory factory, Duration connectionUploadTimeout) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractHttp11Protocol) {
                AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
                protocol.setConnectionUploadTimeout((int)connectionUploadTimeout.toMillis());
            }
        });
    }

    private void customizeConnectionLinger(TongWebServletWebServerFactory factory, Duration connectionLinger) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractProtocol) {
                AbstractProtocol protocol = (AbstractProtocol)handler;
                protocol.setConnectionLinger((int)connectionLinger.toMillis());
            }
        });
    }

    private void customizeAsyncTimeout(TongWebServletWebServerFactory factory, Duration asyncTimeout) {
        factory.addConnectorCustomizers(connector -> connector.setAsyncTimeout(asyncTimeout.toMillis()));
    }

    private void customizeAuditLog(TongWebServletWebServerFactory factory, AuditLog log) {
        log.setTargetDir(this.serverProperties.getTongweb().getBasedir());
        factory.addContextLifecycleListeners(event -> {
            if (event.getType().equalsIgnoreCase("after_start")) {
                log.start();
            }
            if (event.getType().equalsIgnoreCase("before_destroy")) {
                log.stop();
            }
        });
    }

    private boolean isPositive(int value) {
        return value > 0;
    }

    private void customizeAcceptCount(ConfigurableTongWebWebServerFactory factory, int acceptCount) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractProtocol) {
                AbstractProtocol protocol = (AbstractProtocol)handler;
                protocol.setAcceptCount(acceptCount);
            }
        });
    }

    private void customizeProcessorCache(ConfigurableTongWebWebServerFactory factory, int processorCache) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractProtocol) {
                ((AbstractProtocol)handler).setProcessorCache(processorCache);
            }
        });
    }

    private void customizeKeepAliveTimeout(ConfigurableTongWebWebServerFactory factory, Duration keepAliveTimeout) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            for (UpgradeProtocol upgradeProtocol : handler.findUpgradeProtocols()) {
                if (!(upgradeProtocol instanceof Http2Protocol)) continue;
                ((Http2Protocol)upgradeProtocol).setKeepAliveTimeout(keepAliveTimeout.toMillis());
            }
            if (handler instanceof AbstractProtocol) {
                AbstractProtocol protocol = (AbstractProtocol)handler;
                protocol.setKeepAliveTimeout((int)keepAliveTimeout.toMillis());
            }
        });
    }

    private void customizeRemoteIpValve(ConfigurableTongWebWebServerFactory factory) {
        TongWebConfig.Remoteip remoteIpProperties = this.serverProperties.getTongweb().getRemoteip();
        String protocolHeader = remoteIpProperties.getProtocolHeader();
        String remoteIpHeader = remoteIpProperties.getRemoteIpHeader();
        if (StringUtils.hasText((String)protocolHeader) || StringUtils.hasText((String)remoteIpHeader) || this.getOrDeduceUseForwardHeaders()) {
            RemoteIpValve valve = new RemoteIpValve();
            valve.setProtocolHeader(StringUtils.hasLength((String)protocolHeader) ? protocolHeader : "X-Forwarded-Proto");
            if (StringUtils.hasLength((String)remoteIpHeader)) {
                valve.setRemoteIpHeader(remoteIpHeader);
            }
            valve.setTrustedProxies(remoteIpProperties.getTrustedProxies());
            valve.setInternalProxies(remoteIpProperties.getInternalProxies());
            try {
                valve.setHostHeader(remoteIpProperties.getHostHeader());
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            valve.setPortHeader(remoteIpProperties.getPortHeader());
            valve.setProtocolHeaderHttpsValue(remoteIpProperties.getProtocolHeaderHttpsValue());
            factory.addEngineValves(new Valve[]{valve});
        }
    }

    private void customizeMaxKeepAliveRequests(ConfigurableTongWebWebServerFactory factory, int maxKeepAliveRequests) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractHttp11Protocol) {
                AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
                protocol.setMaxKeepAliveRequests(maxKeepAliveRequests);
            }
        });
    }

    private void customizeConnectionTimeout(ConfigurableTongWebWebServerFactory factory, Duration connectionTimeout) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractProtocol) {
                AbstractProtocol protocol = (AbstractProtocol)handler;
                protocol.setConnectionTimeout((int)connectionTimeout.toMillis());
            }
        });
    }

    private void customizeRelaxedPathChars(ConfigurableTongWebWebServerFactory factory, String relaxedChars) {
        factory.addConnectorCustomizers(connector -> connector.setProperty("relaxedPathChars", relaxedChars));
    }

    private void customizeRelaxedQueryChars(ConfigurableTongWebWebServerFactory factory, String relaxedChars) {
        factory.addConnectorCustomizers(connector -> connector.setProperty("relaxedQueryChars", relaxedChars));
    }

    private String joinCharacters(List<Character> content) {
        return content.stream().map(String::valueOf).collect(Collectors.joining());
    }

    private boolean getOrDeduceUseForwardHeaders() {
        if (this.serverProperties.getForwardHeadersStrategy() == null) {
            CloudPlatform platform = CloudPlatform.getActive((Environment)this.environment);
            return platform != null && platform.isUsingForwardHeaders();
        }
        return this.serverProperties.getForwardHeadersStrategy().equals((Object)ServerProperties.ForwardHeadersStrategy.NATIVE);
    }

    private void customizeMaxThreads(ConfigurableTongWebWebServerFactory factory, final int maxThreads) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractProtocol) {
                final AbstractProtocol protocol = (AbstractProtocol)handler;
                int targetThread = LicenseProviderFacade.getLimitThreadsByLicense((int)maxThreads);
                protocol.setMaxThreads(targetThread);
                LicenseProviderFacade.registerDynamicLoadingListener((DynamicLoadingListener)new DynamicLoadingListener(){

                    public String getListenerKey() {
                        return "MaxThreads";
                    }

                    public void exec() {
                        if (LicenseProviderFacade.isLimitThreadsByLicense()) {
                            protocol.setMaxThreads(5);
                        } else {
                            int targetThread = LicenseProviderFacade.getLimitThreadsByLicense((int)maxThreads);
                            if (logger.isTraceEnabled()) {
                                logger.trace((Object)("Dynamic loading license file support for number of maxThreads turning. current : " + protocol.getMinSpareThreads() + " change to: " + targetThread));
                            }
                            protocol.setMaxThreads(targetThread);
                        }
                    }
                });
            }
        });
    }

    private void customizeMinThreads(ConfigurableTongWebWebServerFactory factory, final int minSpareThreads) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractProtocol) {
                final AbstractProtocol protocol = (AbstractProtocol)handler;
                int targetThread = LicenseProviderFacade.getLimitThreadsByLicense((int)minSpareThreads);
                protocol.setMinSpareThreads(targetThread);
                LicenseProviderFacade.registerDynamicLoadingListener((DynamicLoadingListener)new DynamicLoadingListener(){

                    public String getListenerKey() {
                        return "MinSpareThreads";
                    }

                    public void exec() {
                        if (LicenseProviderFacade.isLimitThreadsByLicense()) {
                            protocol.setMinSpareThreads(5);
                        } else {
                            int targetThread = LicenseProviderFacade.getLimitThreadsByLicense((int)minSpareThreads);
                            if (logger.isTraceEnabled()) {
                                logger.trace((Object)("Dynamic loading license file support for number of minSpareThreads turning. current : " + protocol.getMinSpareThreads() + " change to: " + targetThread));
                            }
                            protocol.setMinSpareThreads(targetThread);
                        }
                    }
                });
            }
        });
    }

    private void customizeMaxConnections(TongWebServletWebServerFactory factory, int maxConnections) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractProtocol) {
                AbstractProtocol protocol = (AbstractProtocol)handler;
                protocol.setMaxConnections(maxConnections);
            }
        });
    }

    private void customizeMaxHttpHeaderSize(ConfigurableTongWebWebServerFactory factory, int maxHttpHeaderSize) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractHttp11Protocol) {
                AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
                protocol.setMaxHttpHeaderSize(maxHttpHeaderSize);
            }
        });
    }

    private void customizeMaxParameterCount(TongWebServletWebServerFactory factory, int maxParameterCount) {
        factory.addConnectorCustomizers(connector -> connector.setMaxParameterCount(maxParameterCount));
    }

    private void customizeMaxHttpPostSize(TongWebServletWebServerFactory factory, int maxHttpPostSize) {
        factory.addConnectorCustomizers(connector -> connector.setMaxPostSize(maxHttpPostSize));
    }

    private void customizeMaxSavePostSize(TongWebServletWebServerFactory factory, int maxSavePostSize) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractHttp11Protocol) {
                AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
                protocol.setMaxSavePostSize(maxSavePostSize);
            }
        });
    }

    private void customizeMaxSwallowSize(TongWebServletWebServerFactory factory, int maxSwallowSize) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractHttp11Protocol) {
                AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
                protocol.setMaxSwallowSize(maxSwallowSize);
            }
        });
    }

    private void customizeMaxTrailerSize(ConfigurableTongWebWebServerFactory factory, int maxTrailerSize) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractHttp11Protocol) {
                AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
                protocol.setMaxTrailerSize(maxTrailerSize);
            }
        });
    }

    private void customizeMaxHttpFormPostSize(ConfigurableTongWebWebServerFactory factory, int maxHttpFormPostSize) {
        factory.addConnectorCustomizers(connector -> connector.setMaxPostSize(maxHttpFormPostSize));
    }

    private void customizeStaticResources(ConfigurableTongWebWebServerFactory factory) {
        TongWebConfig.Resource resource = this.serverProperties.getTongweb().getResource();
        factory.addContextCustomizers(context -> context.addLifecycleListener(event -> {
            if (event.getType().equals("configure_start")) {
                context.getResources().setCachingAllowed(resource.isAllowCaching());
                if (resource.getCacheTtl() != null) {
                    long ttl = resource.getCacheTtl().toMillis();
                    context.getResources().setCacheTtl(ttl);
                }
            }
        }));
    }

    private void customizeErrorReportValve(ErrorProperties error, ConfigurableTongWebWebServerFactory factory) {
        if (TongWebWebServerFactoryCustomizer.isIncludeStacktraceNever(error)) {
            factory.addContextCustomizers(context -> {
                ErrorReportValve valve = new ErrorReportValve();
                valve.setShowReport(false);
                context.getParent().getPipeline().addValve((Valve)valve);
            });
        }
    }

    private void customizeAccessLog(TongWebServletWebServerFactory factory, TongWebConfig.Accesslog accessLogConfig) {
        ExtendedAccessLogValve valve;
        PropertyMapper map = PropertyMapper.get();
        if (accessLogConfig.isLogExtend()) {
            valve = new ExtendedAccessLogValve();
            if (accessLogConfig.getPattern().contains("%") || accessLogConfig.getPattern().equalsIgnoreCase("common")) {
                logger.warn((Object)"If setting server.tongweb.accesslog.log-extend=true, need change pattern to extended mode pattern.");
                logger.warn((Object)"for example:");
                logger.warn((Object)"\tserver.tongweb.accesslog.pattern=date time time-taken cs-method cs-uri sc-status");
            }
        } else {
            valve = new AccessLogValve();
        }
        map.from((Object)accessLogConfig.getConditionIf()).to(arg_0 -> ((AccessLogValve)valve).setConditionIf(arg_0));
        map.from((Object)accessLogConfig.getConditionUnless()).to(arg_0 -> ((AccessLogValve)valve).setConditionUnless(arg_0));
        map.from((Object)accessLogConfig.getDirectory()).to(arg_0 -> ((AccessLogValve)valve).setDirectory(arg_0));
        map.from((Object)accessLogConfig.getEncoding()).whenHasText().to(arg_0 -> ((AccessLogValve)valve).setEncoding(arg_0));
        map.from((Object)accessLogConfig.getPattern()).to(arg_0 -> ((AccessLogValve)valve).setPattern(arg_0));
        map.from((Object)accessLogConfig.getPrefix()).to(arg_0 -> ((AccessLogValve)valve).setPrefix(arg_0));
        map.from((Object)accessLogConfig.getSuffix()).to(arg_0 -> ((AccessLogValve)valve).setSuffix(arg_0));
        map.from((Object)accessLogConfig.getLocale()).whenHasText().to(arg_0 -> ((AccessLogValve)valve).setLocale(arg_0));
        map.from((Object)accessLogConfig.isCheckExists()).to(arg_0 -> ((AccessLogValve)valve).setCheckExists(arg_0));
        map.from((Object)accessLogConfig.isRotate()).to(arg_0 -> ((AccessLogValve)valve).setRotatable(arg_0));
        map.from((Object)accessLogConfig.isRenameOnRotate()).to(arg_0 -> ((AccessLogValve)valve).setRenameOnRotate(arg_0));
        map.from((Object)accessLogConfig.getMaxDays()).to(arg_0 -> ((AccessLogValve)valve).setMaxDays(arg_0));
        map.from((Object)accessLogConfig.getFileDateFormat()).to(arg_0 -> ((AccessLogValve)valve).setFileDateFormat(arg_0));
        map.from((Object)accessLogConfig.isIpv6Canonical()).to(arg_0 -> ((AccessLogValve)valve).setIpv6Canonical(arg_0));
        map.from((Object)accessLogConfig.isRequestAttributesEnabled()).to(arg_0 -> ((AccessLogValve)valve).setRequestAttributesEnabled(arg_0));
        map.from((Object)accessLogConfig.isBuffered()).to(arg_0 -> ((AccessLogValve)valve).setBuffered(arg_0));
        map.from((Object)accessLogConfig.getMaxLogMessageBufferSize()).to(arg_0 -> ((AccessLogValve)valve).setMaxLogMessageBufferSize(arg_0));
        factory.addHostValves(new Valve[]{valve});
    }
}

