import request from '@/utils/request';
import { OperLogQuery, OperLogVO } from './types';
import { ApprovalVO,ApprovalQuery } from './types';
import { DataChangeVO,DataChangeQuery } from './types';
import { AxiosPromise } from 'axios';

// 查询审批流程记录
export function listApproval(query: ApprovalQuery): AxiosPromise<ApprovalVO[]> {
  return request({
    url: '/zjk-api/approvalProcessLogs/list',
    method: 'get',
    params: query
  });
}

// 查询数据变更记录
export function getChange( id :string | number) {
  return request({
    url: '/zjk-api/dataChangesLogs/' + id,
    method: 'get'
  });
}

// 查询数据变更记录
export function listDataChange(query: ApprovalQuery): AxiosPromise<[]> {
  return request({
    url: '/zjk-api/dataChangesLogs/list',
    method: 'get',
    params: query
  });
}

// 查询操作日志列表
export function list(query: OperLogQuery): AxiosPromise<OperLogVO[]> {
  return request({
    url: '/monitor/operlog/list',
    method: 'get',
    params: query
  });
}

// 删除操作日志
export function delOperlog(operId: string | number | Array<string | number>) {
  return request({
    url: '/monitor/operlog/' + operId,
    method: 'delete'
  });
}

// 清空操作日志
export function cleanOperlog() {
  return request({
    url: '/monitor/operlog/clean',
    method: 'delete'
  });
}
