export interface ExpertVO {
  /**
   * expertId
   */
  expertId: string | number;

  userId: string;
  /**
   * expertId
   */
  modifiedFields: string;

  rewardType?: string;

  zjkExpertAwardsList?: Array<any>;

  zjkExpertPaperList?: Array<any>;

  zjkExpertPatentList?: Array<any>;

  otherPathList?: Array<any>;

  /**
   * 姓名
   */
  expertName: string;

  /**
   * 性别
   */
  sex: number;

  /**
   * 生日
   */
  birthDate: string;

  /**
   * 联系方式
   */
  contact: string;

  /**
   * 工作单位
   */
  workUnit: string;

  /**
   * 职务
   */
  duty: string;

  /**
   * 政治面貌
   */
  politics: string;

  /**
   * 毕业学校
   */
  graduateSchool: string;

  /**
   * 居住地址 - 省
   */
  province?: string;

  /**
   * 居住地址 - 市
   */
  city?: string;

  /**
   * 居住地址 - 区
   */
  area?: string;

  /**
   * 详细地址
   */
  address?: string;

  /**
   * 专业
   */
  major: string;
  majorList?: Array<{major:string,degree:string}>

  /**
   * 邮箱
   */
  email: string;

  /**
   * 专业技术资格
   */
  professional: string;

  /**
   * 专业技术资格取得时间
   */
  professionalAcquisitionDate: string;

  /**
   * 专业技术资格列表
   */
  professionalList?: Array<{professional:string,professionalDate:string}>;

  /**
   * 从事专业
   */
  workProfessial: string;

  /**
   * 从事专业年限
   */
  workProfessialYear: string | number;

  /**
   * 照片
   */
  photograph: string;

  /**
   * 从事工作或研究领域
   */
  performWorkId: string;
  workArr?: Array<any>;

  /**
   * 其他领域描述
   */
  otherDescribe: string;


  /**
   * 其他领域描述
   */
  otherPath: string;

  /**
   * 主要工作经历
   */
  workExperience: string;

  /**
   * 社会兼职情况
   */
  workPluralistic: string;

  /**
   * 主要论著、业绩成果及获奖情况
   */
  achievement: string;

  /**
   * 论文
   */
  paperpath:string;

  /**
   * 专利
   */
  patentpath:string;

  /**
   * 备注
   */
  remark: string;

  /**
   * 创建人
   */
  createdBy: number;

  /**
   * 创建时间
   */
  createdTime: string;

  /**
   * 修改人
   */
  updatedBy: number;

  /**
   * 修改时间
   */
  updatedTime: string;

  /**
   * 是否删除
   */
  deleteFlag: number;

  /**
   * 状态
   */
  status: number;

  useStatus: boolean;

  /**
   * 审批类型
   */
  approvalType: number;

  /**
   * 数数
   */
  num: number;
  /**
   * 职称等级
   */
  positionTitleLevel: string;
  /**
   * 专家来源
   */
  expertSources: string;
  placeList: Array<string | number>;
  performWork: Array<string | number>;
  isRecommend: string
  unitType: string,
  idCard: string,
  positionTitleLevelStr: string
}

export interface ExpertForm extends BaseEntity {
  /**
   * expertId
   */
  expertId?: string | number;

  /**
   * 姓名
   */
  expertName?: string;

  /**
   * 性别
   */
  sex?: number | undefined;

  /**
   * 生日
   */
  birthDate?: string;

  /**
   * 联系方式
   */
  contact?: string;

  /**
   * 工作单位
   */
  workUnit?: string;

  /**
   * 职务
   */
  duty?: string;

  /**
   * 政治面貌
   */
  politics?: string;

  /**
   * 毕业学校
   */
  graduateSchool?: string;

  /**
   * 专业
   */
  // major?: Array<{major:string,education:string}>;
  major?: string;

  /**
   * 邮箱
   */
  email?: string;

  /**
   * 居住地址 - 省
   */
  province?: string;

  /**
   * 居住地址 - 市
   */
  city?: string;

  /**
   * 居住地址 - 区
   */
  area?: string;

  /**
   * 详细地址
   */
  address?: string;

  /**
   * 专业技术资格
   */
  professional?: string;

  /**
   * 专业技术资格取得时间
   */
  professionalAcquisitionDate?: string;

  /**
   * 从事专业
   */
  workProfessial?: string;

  /**
   * 从事专业年限
   */
  workProfessialYear?: number | string;

  /**
   * 照片
   */
  photograph?: string;

  /**
   * 从事工作或研究领域
   */
  performWork?: Array<string | number>;
  performWorkId?: string;

  /**
   * 其他领域描述
   */
  otherDescribe?: string;

  /**
   * 主要工作经历
   */
  workExperience?: string;

  /**
   * 社会兼职情况
   */
  workPluralistic?: string;

  /**
   * 主要论著、业绩成果及获奖情况
   */
  achievement?: string;

  /**
   * 论文
   */
  paperpath:string | Array<string>

  /**
   * 专利
   */
  patentpath:string | Array<string>

  /**
   * 备注
   */
  remark?: string;

  /**
   * 创建人
   */
  createdBy?: number;

  /**
   * 创建时间
   */
  createdTime?: string;

  /**
   * 修改人
   */
  updatedBy?: number;

  /**
   * 修改时间
   */
  updatedTime?: string;

  /**
   * 是否删除
   */
  deleteFlag?: number;

}

export interface ExpertQuery extends PageQuery {

  /**
   * expertId
   */
  expertId?: string | number;

  /**
   * 姓名
   */
  expertName?: string;

  /**
   * 性别
   */
  sex?: number;

  /**
   * 生日
   */
  birthDate?: string;

  /**
   * 联系方式
   */
  contact?: string;

  /**
   * 工作单位
   */
  workUnit?: string;

  /**
   * 职务
   */
  duty?: string;

  /**
   * 政治面貌
   */
  politics?: string;

  /**
   * 毕业学校
   */
  graduateSchool?: string;

  /**
   * 专业
   */
  major?: string;

  /**
   * 邮箱
   */
  email?: string;

  /**
   * 专业技术资格
   */
  professional?: string;

  /**
   * 专业技术资格取得时间
   */
  professionalAcquisitionDate?: string;

  /**
   * 从事专业
   */
  workProfessial?: string;

  /**
   * 从事专业年限
   */
  workProfessialYear?: number | string;

  /**
   * 照片
   */
  photograph?: string;

  /**
   * 从事工作或研究领域
   */
  performWorkId?: string | number;

  /**
   * 其他领域描述
   */
  otherDescribe?: string;

  /**
   * 主要工作经历
   */
  workExperience?: string;

  /**
   * 社会兼职情况
   */
  workPluralistic?: string;

  /**
   * 主要论著、业绩成果及获奖情况
   */
  achievement?: string;

  /**
   * 创建人
   */
  createdBy?: number;

  /**
   * 创建时间
   */
  createdTime?: string;

  /**
   * 修改人
   */
  updatedBy?: number;

  /**
   * 修改时间
   */
  updatedTime?: string;

  /**
   * 是否删除
   */
  deleteFlag?: number;

  /**
   * 日期范围参数
   */
  params?: any;


  /**
   * 状态
   */
  status: number;
}



