import request from '@/utils/request';
import { AxiosPromise } from 'axios';
import {HomeVO, HomeForm, HomeQuery, CountVO, ListVO, expertV0, AllCountVO} from '@/api/expert/homePage/types';


/**
 * 查询所有统计-机构管理员
 * @param query
 * @returns {*}
 */

export const getExpertAllCount = (): AxiosPromise<AllCountVO> => {
  return request({
    url: '/zjk-api/zjkHome/getJgStatistics',
    method: 'get'
  });
};


/**
 * 查询已入库专家总人数-机构管理员
 * @param query
 * @returns {*}
 */

export const getExpertCount = (): AxiosPromise<CountVO> => {
  return request({
    url: '/zjk-api/expert/getExpertCount',
    method: 'get'
  });
};

/**
 * 获取黑名单专家总人数-机构管理员
 * @param query
 * @returns {*}
 */

export const getBlacklistCount = (): AxiosPromise<CountVO> => {
  return request({
    url: '/zjk-api/creditUser/getBlacklistCount',
    method: 'get'
  });
};

/**
 * 获取评审项目数量-机构管理员
 * @param query
 * @returns {*}
 */

export const getReviewProjectCount = (): AxiosPromise<CountVO> => {
  return request({
    url: '/zjk-api/reviewPhase/getReview/count',
    method: 'get'
  });
};

/**
 * 获取项目总结完成数-机构管理员
 * @param query
 * @returns {*}
 */

export const getProjectSummaryCount = (): AxiosPromise<CountVO> => {
  return request({
    url: '/zjk-api/productSummarize/getCount',
    method: 'get'
  });
};

/**
 * 获取优秀信用专家人数-机构管理员
 * @param query
 * @returns {*}
 */

export const getExcellentCreditExpertCount = (): AxiosPromise<CountVO> => {
  return request({
    url: '/zjk-api/creditUser/getCount',
    method: 'get'
  });
};

/**
 * 获取专家请假总次数-机构管理员
 * @param query
 * @returns {*}
 */

export const getExpertLeaveCount = (): AxiosPromise<CountVO> => {
  return request({
    url: '/zjk-api/leave/stsNum',
    method: 'get'
  });
};

/**
 * 获取项目总数-厅局管理员
 * @param query
 * @returns {*}
 */

export const getProductPanoramaCount = (): AxiosPromise<CountVO> => {
  return request({
    url: '/zjk-api/product/getProductPanoramaCount',
    method: 'get'
  });
};

/**
 * 获取专家信息
 * @param query
 * @returns {*}
 */

export const getExpertInfoData = (): AxiosPromise<expertV0> => {
  return request({
    url: '/zjk-api/expert/getExpertBaseInfo',
    method: 'get'
  });
};

/**
 * 查询待审批专家列表
 * @param query
 * @returns {*}
 */

export const getPendingApprovalList = (query?: HomeQuery): AxiosPromise<HomeVO[]> => {
  return request({
    url: '/zjk-api/expert/pendingApproval',
    method: 'get',
    params: query
  });
};

/**
 * 查询待评价专家-管理员
 * @param query
 * @returns {*}
 */

export const getExpertEvaluatedList = (query?: HomeQuery): AxiosPromise<HomeVO[]> => {
  return request({
    url: '/zjk/evaluate/listToOrg',
    method: 'get',
    params: query
  });
};

/**
 * 查询机构管理员-请假审批
 * @param query
 * @returns {*}
 */

export const getMechanismLeaveApprovalList = (query?: HomeQuery): AxiosPromise<HomeVO[]> => {
  return request({
    url: '/zjk-api/leave/splist',
    method: 'get',
    params: query
  });
};

/**
 * 查询待接受项目列表-专家
 * @param query
 * @returns {*}
 */

export const getAcceptProjectList = (query?: HomeQuery): AxiosPromise<HomeVO[]> => {
  return request({
    url: '/zjk-api/leave/prosForAccept',
    method: 'get',
    params: query
  });
};

/**
 * 查询待参评项目列表-专家
 * @param query
 * @returns {*}
 */

export const getParticipatingProjectsList = (query?: HomeQuery): AxiosPromise<HomeVO[]> => {
  return request({
    url: '/zjk-api/leave/prosForJoin',
    method: 'get',
    params: query
  });
};

/**
 * 查询待互评专家-专家
 * @param query
 * @returns {*}
 */
export const listMutual = (query?: HomeQuery): AxiosPromise<ListVO[]> => {
  return request({
    url: '/zjk-api/evaluate/listToZj',
    method: 'get',
    params: query
  });
};

/**
 * 查询待互评专家-项目
 * @param query
 * @returns {*}
 */
export const listToXm = (query?: HomeQuery): AxiosPromise<ListVO[]> => {
  return request({
    url: '/zjk-api/evaluate/listToXm',
    method: 'get',
    params: query
  });
};


/**
 * 查询expert详细
 * @param id
 */
export const getExpert = (id: string | number): AxiosPromise<HomeVO> => {
  return request({
    url: '/zjk-api/expert/' + id,
    method: 'get'
  });
};

/**
 * 新增expert
 * @param data
 */
export const addExpert = (data: HomeForm) => {
  return request({
    url: '/zjk-api/expert/save',
    method: 'post',
    data: data
  });
};

/**
 * 修改expert
 * @param data
 */
export const updateExpert = (data: HomeForm) => {
  return request({
    url: '/zjk-api/expert/update',
    method: 'post',
    data: data
  });
};

/**
 * 删除expert
 * @param id
 */
export const delExpert = (id: string | number | Array<string | number>) => {
  return request({
    url: '/zjk-api/expert/delete/' + id,
    method: 'get'
  });
};

export const setLeave = (query: any): AxiosPromise<any> => {
  return request({
    url: '/zjk/leave/leaveForPro',
    method: 'post',
    data: query
  });
};
export const setAccept = (query: any): AxiosPromise<any> => {
  return request({
    url: '/zjk/leave/setAccept',
    method: 'post',
    data: query
  });
};
