import request from '@/utils/request';
import { AxiosPromise } from 'axios';
import {CountVO,} from '@/api/backStage/expertManagement/expertStatisticalReport/types';

/**
 * 专家入库总人数
 * @param query
 * @returns {*}
 */

export const getExpertWarehousingCount = (): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/expert/getExpertCount',
    method: 'get'
  });
};

/**
 * 在库论文总数
 * @param query
 * @returns {*}
 */

export const getExpertPaperCount = (): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/expertPaper/getExpertPaperCount',
    method: 'get'
  });
};

/**
 * 在库专利总数
 * @param query
 * @returns {*}
 */

export const getExpertPatentCount = (): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/expertPatent/getExpertPatentCount',
    method: 'get'
  });
};

/**
 * 在库政治面貌人数
 * @param query
 * @returns {*}
 */

export const getExpertPoliticalOutlookCount = (): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/expert/getPoliticsCount',
    method: 'get'
  });
};

/**
 * 本年度 入库专家
 * @param query
 * @returns {*}
 */

export const getExpertNewTotalCount = (): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/expert/approval-time-count',
    method: 'get'
  });
};

/**
 * 各个领域人数
 * @param query
 * @returns {days}
 */

export const getExpertFieldData = (query): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/expert/getExpertPerformWorkCount',
    method: 'get',
    params: query
  });
};

/**
 * 入库专家年龄区间
 * @param query
 * @returns {*}
 */

export const getExpertAgeRangeData = (): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/expert/getAgeRangeStatistics',
    method: 'get'
  });
};

/**
 * 入库专家各个学历的人数
 * @param query
 * @returns {*}
 */

export const getExpertEducationData = (): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/expertMajor/getExpertMajorCount',
    method: 'get'
  });
};

/**
 * 趋势分析
 * @param query
 * @returns {* startTime endTime}
 */

export const getExpertTrendAnalysisData = (query): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/expertLog/getApplicationResults',
    method: 'get',
    params: query
  });
};

/**
 * 入库分析
 * @param query
 * @returns {* startTime endTime}
 */

export const getExpertWarehousingData = (query): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/expert/getApprovalTimeAnalysis',
    method: 'get',
    params: query
  });
};


