export interface RetirementRecordsVO {
  /**
   * id
   */
  id: string | number;

  /**
   * 专家 id
   */
  experId: string | number;

  /**
   * 用户 id
   */
  userId: string | number;

  workUnit: string;
  expertName: string;
  idCard: string;
  contact: string;
  reason: string;

  /**
   * 退休时间
   */
  retirementTime: string;

  /**
   * 专家状态 4 离职 5退休
   */
  expertStatus: number;

}

export interface RetirementRecordsForm extends BaseEntity {
  /**
   * id
   */
  id?: string | number;

  /**
   * 专家 id
   */
  experId?: string | number;

  /**
   * 用户 id
   */
  userId?: string | number;

  /**
   * 退休时间
   */
  retirementTime?: string;

  /**
   * 专家状态 4 离职 5退休
   */
  expertStatus?: number;

}

export interface RetirementRecordsQuery extends PageQuery {

  /**
   * 专家状态 4 离职 5退休
   */
  expertStatus?: number;

  contact?: string;

  idCard?: string;

    /**
     * 日期范围参数
     */
    params?: any;
}



