import request from '@/utils/request';
import { AxiosPromise } from 'axios';
import { InvoiceVO, InvoiceForm, InvoiceQuery } from '@/api/expertMoneyConfig/expertMoneyInfo/types';

/**
 * 查询发票列表
 * @param query
 * @returns {*}
 */

export const listInvoice = (query?: InvoiceQuery): AxiosPromise<InvoiceVO[]> => {
  return request({
    url: '/zjk-api/invoice/list',
    method: 'get',
    params: query
  });
};

/**
 * 查询项目抽取专家列表
 * @param query
 * @returns {*}
 */

export const getExpertList = (query?: any): AxiosPromise<any[]> => {
  return request({
    url: '/zjk-api/moneyInfo/expertList',
    method: 'get',
    params: query
  });
};

/**
 * 查询发票详细
 * @param id
 */
export const getInvoice = (id: string | number): AxiosPromise<InvoiceVO> => {
  return request({
    url: '/zjk-api/invoice/' + id,
    method: 'get'
  });
};

/**
 * 新增发票
 * @param data
 */
export const addInvoice = (data: InvoiceForm) => {
  return request({
    url: '/zjk-api/invoice/add',
    method: 'post',
    data: data
  });
};

/**
 * 修改发票
 * @param data
 */
export const updateInvoice = (data: InvoiceForm) => {
  return request({
    url: '/zjk-api/invoice/edit',
    method: 'post',
    data: data
  });
};

/**
 * 删除发票
 * @param id
 */
export const delInvoice = (id: string | number | Array<string | number>) => {
  return request({
    url: '/zjk-api/invoice/delete/' + id,
    method: 'get'
  });
};

/**
 * 审核发票
 */
export const auditInvoices = (id: string | number) => {
  return request({
    url: '/zjk-api/invoice/check/' + id,
    method: 'get'
  });
};

/**
 * 获取结算单列表
 */
export const getSettlement = (query: any) => {
  return request({
    url: '/zjk-api/moneyInfo/settleList',
    method: 'get',
    params: query
  });
};
