import request from '@/utils/request';
import { AxiosPromise } from 'axios';
import { ExpertMoneyConfigVO, ExpertMoneyConfigForm, ExpertMoneyConfigQuery } from '@/api/expertMoneyConfig/types';

/**
 * 查询专家费用管理列表
 * @param query
 * @returns {*}
 */

export const listExpertMoneyConfig = (query?: ExpertMoneyConfigQuery): AxiosPromise<ExpertMoneyConfigVO[]> => {
  return request({
    url: '/zjk/expertMoneyConfig/list',
    method: 'get',
    params: query
  });
};

/**
 * 查询专家费用管理详细
 * @param moneyId
 */
export const getExpertMoneyConfig = (moneyId: string | number): AxiosPromise<ExpertMoneyConfigVO> => {
  return request({
    url: '/zjk/expertMoneyConfig/' + moneyId,
    method: 'get'
  });
};

/**
 * 新增专家费用管理
 * @param data
 */
export const addExpertMoneyConfig = (data: ExpertMoneyConfigForm) => {
  return request({
    url: '/zjk/expertMoneyConfig/add',
    method: 'post',
    data: data
  });
};

/**
 * 修改专家费用管理
 * @param data
 */
export const updateExpertMoneyConfig = (data: ExpertMoneyConfigForm) => {
  return request({
    url: '/zjk/expertMoneyConfig/edit',
    method: 'post',
    data: data
  });
};

/**
 * 删除专家费用管理
 * @param moneyId
 */
export const delExpertMoneyConfig = (moneyId: string | number | Array<string | number>) => {
  return request({
    url: '/zjk-api/expertMoneyConfig/remove/' + moneyId,
    method: 'get'
  });
};
