import request from '@/utils/request';
import { AxiosPromise } from 'axios';
import { LeaveLogVO, LeaveLogQuery } from './types';

interface paramsQuery {
  pageNum: string | number;
  pageSize: number;
  startDate: string | number;
  endDate: string | number;
  gid: string | number;
  status: string | number
}
export const getLeaveList = (query?: paramsQuery): AxiosPromise<LeaveLogVO[]> => {
  return request({
    url: '/zjk/leave/list',
    method: 'get',
    params: query
  });
};
