import request from '@/utils/request';
import { AxiosPromise } from 'axios';
import { LearningResourceVO, LearningResourceForm, LearningResourceQuery } from '@/api/study/resource/types';

/**
 * 查询资源管理列表
 * @param query
 * @returns {*}
 */

export const listLearningResource = (query?: LearningResourceQuery): AxiosPromise<LearningResourceVO[]> => {
  return request({
    url: '/zjk/learningResource/list',
    method: 'get',
    params: query
  });
};

/**
 * 查询资源管理详细
 * @param id
 */
export const getLearningResource = (id: string | number): AxiosPromise<LearningResourceVO> => {
  return request({
    url: '/zjk/learningResource/' + id,
    method: 'get'
  });
};

/**
 * 上架/下架
 * @param data
 */
export const updateJiaZi = (data) => {
  return request({
    url: '/zjk-api/learningResource/update/status',
    method: 'post',
    data: data
  });
};

export const updateLessonJiaZi = (data) => {
  return request({
    url: '/zjk-api/learningCourse/update/status',
    method: 'post',
    data: data
  });
};

/**
 * 新增资源管理
 * @param data
 */
export const addLearningResource = (data: LearningResourceForm) => {
  return request({
    url: '/zjk/learningResource',
    method: 'post',
    data: data
  });
};

/**
 * 修改资源管理
 * @param data
 */
export const updateLearningResource = (data: LearningResourceForm) => {
  return request({
    url: '/zjk/learningResource/update',
    method: 'post',
    data: data
  });
};

/**
 * 删除资源管理
 * @param id
 */
export const delLearningResource = (id: string | number | Array<string | number>) => {
  return request({
    url: '/zjk/learningResource/deleted/' + id,
    method: 'get'
  });
};
