export interface LearningResourceVO {
  /**
   * id
   */
  id: string | number;

  /**
   * 资源编号
   */
  resourceName: string;

  /**
   * 资源分类
   */
  resourceClassify: string;

  /**
   * 资源类型
   */
  resourceType: string;

  /**
   * 资源简介
   */
  resourceBrief: string;

  /**
   * 发布时间
   */
  resourceTime: string;

  /**
   * 作者
   */
  author: string;

  /**
   * 发表期刊
   */
  publishJournal: string;

  /**
   * 期刊号
   */
  journalNo: string;

  /**
   * 论文标题
   */
  paperTitle: string;

  /**
   * 状态
   */
  status: string;

  url:string;
  originalName: string;
}

export interface LearningResourceForm extends BaseEntity {
  /**
   * id
   */
  id?: string | number;

  /**
   * 资源编号
   */
  resourceName?: string;

  /**
   * 资源分类
   */
  resourceClassify?: string;

  /**
   * 资源类型
   */
  resourceType?: string;

  /**
   * 资源简介
   */
  resourceBrief?: string;

  /**
   * 发布时间
   */
  resourceTime?: string;

  /**
   * 作者
   */
  author?: string;

  /**
   * 发表期刊
   */
  publishJournal?: string;

  /**
   * 期刊号
   */
  journalNo?: string;

  /**
   * 论文标题
   */
  paperTitle?: string;

  /**
   * 论文附件
   */
  paperAccessory?: string;

  /**
   * 状态
   */
  status?: string;

}

export interface LearningResourceQuery extends PageQuery {

  /**
   * 资源编号
   */
  resourceName?: string;

  /**
   * 资源分类
   */
  resourceClassify?: string;

  /**
   * 资源类型
   */
  resourceType?: string;

  /**
   * 资源简介
   */
  resourceBrief?: string;

  /**
   * 发布时间
   */
  resourceTime?: string;

  /**
   * 作者
   */
  author?: string;

  /**
   * 发表期刊
   */
  publishJournal?: string;

  /**
   * 期刊号
   */
  journalNo?: string;

  /**
   * 论文标题
   */
  paperTitle?: string;

  /**
   * 状态
   */
  status?: string;

  /**
   * 开始时间
   */
  startTime?: string;

  /**
   * 结束时间
   */
  endTime?: string;

    /**
     * 日期范围参数
     */
    params?: any;
}



