export interface PlanQuery {

  /**
   * 计划名称
   */
  planName: string;
}

export interface PlanVO {
  /**
   * expertId
   */
  id: string | number;

  /**
   * 计划名称
   */
  planName: string;

  /**
   * 学习目标
   */
  target: string;

  /**
   * 计划执行开始时间
   */
  planStartTime: string;

  /**
   * 计划执行截止时间
   */
  planEndTime: string;

  /**
   * 学习内容
   */
  content: Array<any>;
}

interface FormType {
  planName: string;
  date: Array<string>;
  target: string;
  content: Array<{
    classify: string | number;
    courseName: string | number;
    courseLists: Array<any>;
  }>;
}

interface RulesType {
  planName: Array<{ required: boolean; message: string; trigger: string }>;
  date: Array<{ required: boolean; message: string; trigger: string }>;
  target: Array<{ required: boolean; message: string; trigger: string }>;
  classify: Array<{ required: boolean; message: string; trigger: string }>;
  courseName: Array<{ required: boolean; message: string; trigger: string }>;
}

export interface StateData {
  form: FormType;
  rules: RulesType;
}

