import request from '@/utils/request';
import { AxiosPromise } from 'axios';

export const getData = (query): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/learningMaterials/list',
    method: 'get',
    params: query
  });
};

export const addFile = (query): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/learningMaterials/add',
    method: 'post',
    data: query
  });
};
export const delFile = (id): AxiosPromise<any> => {
  return request({
    url: `/zjk-api/learningMaterials/delete/${id}`,
    method: 'get',
  });
};
export const logLearn = (id): AxiosPromise<any> => {
  return request({
    url: `/zjk-api/learningCreditRecord/add`,
    method: 'post',
    data:{
      learningId: id
    }
  });
};