export interface EnterVO {
  /**
   * expertId
   */
  expertId: string | number;
  id: string | number;

  /**
   * 姓名
   */
  name: string;
  // expertName: string;

  /**
   * 性别
   */
  sex: number;

  /**
   * 生日
   */
  birthDate: string;

  /**
   * 联系方式
   */
  contactInfo: string;
  // contact: string;

  /**
   * 工作单位
   */
  organization: string;
  // workUnit: string;

  /**
   * 职务
   */
  position: string;
  // duty: string;

  /**
   * 入库结果
   */
  entryResult: string;

  /**
   * 申请时间
   */
  applicationTime: string;
  
  /**
   * 驳回理由
   */
  rejectionReason: string;
  // rejectReason: string;

  /**
   * 政治面貌
   */
  // politics: string;

  /**
   * 毕业学校
   */
  // graduateSchool: string;

  /**
   * 专业
   */
  // major: string;

  /**
   * 邮箱
   */
  // email: string;

  /**
   * 专业技术资格
   */
  // professional: string;

  /**
   * 专业技术资格取得时间
   */
  // professionalAcquisitionDate: string;

  /**
   * 从事专业
   */
  // workProfessial: string;

  /**
   * 从事专业年限
   */
  // workProfessialYear: number;

  /**
   * 照片
   */
  // photograph: string;

  /**
   * 从事工作或研究领域
   */
  // performWorkId: string | number;

  /**
   * 其他领域描述
   */
  // otherDescribe: string;

  /**
   * 主要工作经历
   */
  // workExperience: string;

  /**
   * 社会兼职情况
   */
  // workPluralistic: string;

  /**
   * 主要论著、业绩成果及获奖情况
   */
  // achievement: string;

  /**
   * 备注
   */
  // remark: string;

  /**
   * 创建人
   */
  createdBy: number;

  /**
   * 创建时间
   */
  createdTime: string;

  /**
   * 修改人
   */
  updatedBy: number;

  /**
   * 修改时间
   */
  updatedTime: string;

  /**
   * 是否删除
   */
  deleteFlag: number;


  /**
   * 审批类型
   */
  approvalType: number;


}

export interface EnterForm extends BaseEntity {
  /**
   * expertId
   */
  expertId?: string | number;

  /**
   * 姓名
   */
  expertName?: string;

  /**
   * 性别
   */
  sex?: number | undefined;

  /**
   * 生日
   */
  birthDate?: string;

  /**
   * 联系方式
   */
  contact?: string;

  /**
   * 工作单位
   */
  workUnit?: string;

  /**
   * 职务
   */
  duty?: string;

  /**
   * 政治面貌
   */
  politics?: string;

  /**
   * 毕业学校
   */
  graduateSchool?: string;

  /**
   * 专业
   */
  major?: string;

  /**
   * 邮箱
   */
  email?: string;

  /**
   * 专业技术资格
   */
  professional?: string;

  /**
   * 专业技术资格取得时间
   */
  professionalAcquisitionDate?: string;

  /**
   * 从事专业
   */
  workProfessial?: string;

  /**
   * 从事专业年限
   */
  workProfessialYear?: number;

  /**
   * 照片
   */
  photograph?: string;

  /**
   * 从事工作或研究领域
   */
  performWork?: Array<string | number>;
  performWorkId?: string;

  /**
   * 其他领域描述
   */
  otherDescribe?: string;

  /**
   * 主要工作经历
   */
  workExperience?: string;

  /**
   * 社会兼职情况
   */
  workPluralistic?: string;

  /**
   * 主要论著、业绩成果及获奖情况
   */
  achievement?: string;

  /**
   * 备注
   */
  remark?: string;

  /**
   * 创建人
   */
  createdBy?: number;

  /**
   * 创建时间
   */
  createdTime?: string;

  /**
   * 修改人
   */
  updatedBy?: number;

  /**
   * 修改时间
   */
  updatedTime?: string;

  /**
   * 是否删除
   */
  deleteFlag?: number;

  /**
   * 审批人
   */
  approver: string;

  /**
   * 审批类型
   */
  approvalType: number;

  /**
   * 审批意见
   */
  approvalOpinion : string;


}

export interface EnterQuery extends PageQuery {

  /**
   * expertId
   */
  expertId?: string | number;

  /**
   * 姓名
   */
  name?: string;

  /**
   * 工作单位
   */
  organization?: string;

  /**
   * 入库结果
   */
  entryResult: string;

  /**
   * 申请时间 开始日期
   */
  applyStartTime: string;

  /**
   * 申请时间 结束日期
   */
  applyEndTime: string;

  /**
   * 性别
   */
  // sex?: number;

  /**
   * 生日
   */
  // birthDate?: string;

  /**
   * 联系方式
   */
  // contact?: string;

  /**
   * 职务
   */
  // duty?: string;

  /**
   * 政治面貌
   */
  // politics?: string;

  /**
   * 毕业学校
   */
  // graduateSchool?: string;

  /**
   * 专业
   */
  // major?: string;

  /**
   * 邮箱
   */
  // email?: string;

  /**
   * 专业技术资格
   */
  // professional?: string;

  /**
   * 专业技术资格取得时间
   */
  // professionalAcquisitionDate?: string;

  /**
   * 从事专业
   */
  // workProfessial?: string;

  /**
   * 从事专业年限
   */
  // workProfessialYear?: number;

  /**
   * 照片
   */
  // photograph?: string;

  /**
   * 从事工作或研究领域
   */
  // performWorkId?: string | number;

  /**
   * 其他领域描述
   */
  // otherDescribe?: string;

  /**
   * 主要工作经历
   */
  // workExperience?: string;

  /**
   * 社会兼职情况
   */
  // workPluralistic?: string;

  /**
   * 主要论著、业绩成果及获奖情况
   */
  // achievement?: string;

  /**
   * 创建人
   */
  createdBy?: number;

  /**
   * 创建时间
   */
  createdTime?: string;

  /**
   * 修改人
   */
  updatedBy?: number;

  /**
   * 修改时间
   */
  updatedTime?: string;

  /**
   * 是否删除
   */
  deleteFlag?: number;

  /**
   * 日期范围参数
   */
  params?: any;


  /**
   * 状态
   */
  // status: string;
}



