import request from '@/utils/request';
import { AxiosPromise } from 'axios';
import { RetirementRecordsVO, RetirementRecordsForm, RetirementRecordsQuery } from '@/api/expert/retirementRecords/types';

/**
 * 查询专家退休记录列表
 * @param query
 * @returns {*}
 */

export const listRetirementRecords = (query?: RetirementRecordsQuery): AxiosPromise<RetirementRecordsVO[]> => {
  return request({
    url: '/zjk-api/retirementRecords/list',
    method: 'get',
    params: query
  });
};

/**
 * 查询专家退休记录详细
 * @param id
 */
export const getRetirementRecords = (id: string | number): AxiosPromise<RetirementRecordsVO> => {
  return request({
    url: '/zjk-api/retirementRecords/' + id,
    method: 'get'
  });
};

/**
 * 新增专家退休记录
 * @param data
 */
export const addRetirementRecords = (data: RetirementRecordsForm) => {
  return request({
    url: '/zjk-api/retirementRecords',
    method: 'post',
    data: data
  });
};

/**
 * 修改专家退休记录
 * @param data
 */
export const updateRetirementRecords = (data: RetirementRecordsForm) => {
  return request({
    url: '/zjk-api/retirementRecords',
    method: 'put',
    data: data
  });
};

/**
 * 删除专家退休记录
 * @param id
 */
export const delRetirementRecords = (id: string | number | Array<string | number>) => {
  return request({
    url: '/zjk-api/retirementRecords/' + id,
    method: 'delete'
  });
};
