import request from '@/utils/request';
import { AxiosPromise } from 'axios';
import { ProjectVO, ProjectForm, ProjectQuery } from '@/api/project/review/types';

/**
 * 查询【请填写功能名称】列表
 * @param query
 * @returns {*}
 */

export const listProject = (query?: ProjectQuery): AxiosPromise<ProjectVO[]> => {
  return request({
    url: '/zjk/reviewPhase/review/product/list',
    method: 'get',
    params: query
  });
};

/**
 * 查询【请填写功能名称】详细
 * @param revision
 */
export const getProject = (revision: string | number): AxiosPromise<ProjectVO> => {
  return request({
    url: '/zjk-api/reviewPhase/getInfo/' + revision,
    method: 'get'
  });
};

/**
 * 新增【请填写功能名称】
 * @param data
 */
export const addProject = (data: ProjectForm) => {
  return request({
    url: '/zjk/project',
    method: 'post',
    data: data
  });
};

/**
 * 修改【请填写功能名称】
 * @param data
 */
export const updateProject = (data: ProjectForm) => {
  return request({
    url: '/zjk/project',
    method: 'put',
    data: data
  });
};

/**
 * 删除【请填写功能名称】
 * @param revision
 */
export const delProject = (revision: string | number | Array<string | number>) => {
  return request({
    url: '/zjk/project/' + revision,
    method: 'delete'
  });
};
