import request from '@/utils/request';
import { AxiosPromise } from 'axios';

interface paramsQuery {
  pageNum: string | number;
  pageSize: number;
  expertName: string | number;
  courseName: string | number;
}
export const getAssessmentList = (query?: paramsQuery): AxiosPromise<any[]> => {
  return request({
    url: '/zjk/learningEvaluate/list',
    method: 'get',
    params: query
  });
};


export const setAssessment = (data: any) => {
  return request({
    url: '/zjk/learningEvaluate/add',
    method: 'post',
    data: data
  });
};

export const updateAssessment = (data: any) => {
  return request({
    url: '/zjk/learningEvaluate/edit',
    method: 'post',
    data: data
  });
};

export const delAssessment = (id: string | number) => {
  return request({
    url: '/zjk/learningEvaluate/delete/' + id,
    method: 'get'
  });
}
