import { to as tos } from 'await-to-js';
import router from './router';
import NProgress from 'nprogress';
import 'nprogress/nprogress.css';
import { getToken } from '@/utils/auth';
import { isHttp } from '@/utils/validate';
import { isRelogin } from '@/utils/request';
import useUserStore from '@/store/modules/user';
import useSettingsStore from '@/store/modules/settings';
import usePermissionStore from '@/store/modules/permission';
import { WHITE_LIST } from '@/config';

NProgress.configure({ showSpinner: false });
router.beforeEach(async (to, from, next) => {
  NProgress.start();
  if (useUserStore().tenantList.length == 0) {
    await useUserStore().initTenantList();
  }
  if (getToken()) {
    to.meta.title && useSettingsStore().setTitle(to.meta.title);
    /* has token*/
    if (to.path.includes('login')) {
      next({ path: '/' });
      NProgress.done();
    } else if (WHITE_LIST.indexOf(to.path as string) !== -1) {
      next();
    } else {
      if (useUserStore().roles.length === 0) {
        isRelogin.show = true;
        // 判断当前用户是否已拉取完user_info信息
        const [err] = await tos(useUserStore().getInfo());
        if (err) {
          await useUserStore().logout();
          if (err.toString() != 'token过期') {
            ElNotification({
              title: '提示',
              message: err.toString(),
              type: 'error'
            });
          }
          next({ path: '/' });
        } else {
          isRelogin.show = false;
          const accessRoutes = await usePermissionStore().generateRoutes();
          let routerArr = [...accessRoutes];
          // 根据roles权限生成可访问的路由表
          routerArr.forEach((route) => {
            if (!isHttp(route.path)) {
              router.addRoute(route); // 动态添加可访问路由表
            }
          });
          // @ts-ignore
          next({ path: to.path, replace: true, params: to.params, query: to.query, hash: to.hash, name: to.name as string }); // hack方法 确保addRoutes已完成
        }
      } else {
        next();
      }
    }
  } else {
    // 没有token
    let domain = useUserStore()
      .tenantList.map((e) => e.domain)
      .map((e) => {
        return [`/${e}/expert/login`, `/${e}/org/login`];
      })
      .flat(1);
    let WHITE_LIST_ARR = [...WHITE_LIST, ...domain];
    if (WHITE_LIST_ARR.indexOf(to.path as string) !== -1) {
      next();
    } else {
      // 在免登录白名单，直接进入
      let res = await useUserStore().callbackBySXZWFW();
      if (res) {
        next((res as string) || '/homePage');
      }
      next('/login');
      NProgress.done();
    }
  }
});

router.afterEach(() => {
  NProgress.done();
});
