export interface AnnualInspectionRecordsVO {
  /**
   * id
   */
  id: string | number;

  /**
   * 用户 id
   */
  userId: string | number;

  /**
   * 专家 id
   */
  expertId: string | number;

  /**
   * 年检记录编号
   */
  recordsSn: string;

  /**
   * 年检审核编号
   */
  annualInspectionSn: string;

  /**
   * 年检名称
   */
  annualInspectionName: string;

  /**
   * 审核方式(1 人工年检 2 自动年检)
   */
  auditType: string;

  /**
   * 年检状态(1 待年检 2 已通过 3 未通过)
   */
  annualInspectionStatus: string;

  /**
   * 审核时间
   */
  auditTime: string;

}

export interface AnnualInspectionRecordsForm extends BaseEntity {
  /**
   * id
   */
  id?: string | number;

  /**
   * 用户 id
   */
  userId?: string | number;

  /**
   * 专家 id
   */
  expertId?: string | number;

  /**
   * 年检记录编号
   */
  recordsSn?: string;

  /**
   * 年检审核编号
   */
  annualInspectionSn?: string;

  /**
   * 年检名称
   */
  annualInspectionName?: string;

  /**
   * 审核方式(1 人工年检 2 自动年检)
   */
  auditType?: string;

  /**
   * 年检状态(1 待年检 2 已通过 3 未通过)
   */
  annualInspectionStatus?: string;

  /**
   * 审核时间
   */
  auditTime?: string;

}

export interface AnnualInspectionRecordsQuery extends PageQuery {

  /**
   * 用户 id
   */
  userId?: string | number;

  identify?: Array<string>;

  /**
   * 专家 id
   */
  expertId?: string | number;

  /**
   * 年检记录编号
   */
  recordsSn?: string;

  /**
   * 年检审核编号
   */
  annualInspectionSn?: string;

  /**
   * 年检名称
   */
  annualInspectionName?: string;

  /**
   * 审核方式(1 人工年检 2 自动年检)
   */
  auditType?: string;

  /**
   * 年检状态(1 待年检 2 已通过 3 未通过)
   */
  annualInspectionStatus?: string;

  /**
   * 审核时间
   */
  auditTime?: string;

    /**
     * 日期范围参数
     */
    params?: any;
}



