import request from '@/utils/request';
import { AxiosPromise } from 'axios';
import { ApprovalVO, ApprovalForm, ApprovalQuery } from '@/api/expert/approval/types';

/**
 * 查询expert列表
 * @param query
 * @returns {*}
 */

export const listExpert = (query?: ApprovalQuery): AxiosPromise<ApprovalVO[]> => {
  return request({
    url: '/zjk-api/expert/list',
    method: 'get',
    params: query
  });
};



/**
 * 查询expert详细
 * @param id
 */
export const getExpert = (id: string | number): AxiosPromise<ApprovalVO> => {
  return request({
    url: '/zjk-api/expert/' + id,
    method: 'get'
  });
};

/**
 * 审批
 * @param data
 */
export const approvalExpert = (data) => {
  return request({
    url: '/zjk-api/expert/approval',
    method: 'post',
    data: data
  });
};
/**
 * 新增expert
 * @param data
 */
export const addExpert = (data: ApprovalForm) => {
  return request({
    url: '/zjk-api/expert/save',
    method: 'post',
    data: data
  });
};

/**
 * 修改expert
 * @param data
 */
export const updateExpert = (data: ApprovalForm) => {
  return request({
    url: '/zjk-api/expert/update',
    method: 'post',
    data: data
  });
};

/**
 * 删除expert
 * @param id
 */
export const delExpert = (id: string | number | Array<string | number>) => {
  return request({
    url: '/zjk-api/expert/delete/' + id,
    method: 'get'
  });
};
