export interface ExpertRecommendVO {
  id:string;
  /**
   * 推荐专家姓名
   */
  expertName: string;

  /**
   * 专家手机号
   */
  expertPhone: string;

  /**
   * 推荐理由
   */
  reason: string;

  /**
   * 推荐状态 1 待审批 2 通过 3 驳回
   */
  status: string;

}

export interface ExpertRecommendForm extends BaseEntity {
  /**
   * id
   */
  id?: string | number;

  /**
   * 专家 id
   */
  expertId?: string | number;

  /**
   * 用户 id
   */
  userId?: string | number;

  /**
   * 推荐专家姓名
   */
  expertName?: string;

  /**
   * 专家手机号
   */
  expertPhone?: string;

  /**
   * 推荐理由
   */
  reason?: string;

  /**
   * 推荐状态 1 待审批 2 通过 3 驳回
   */
  status?: string;

}

export interface ExpertRecommendQuery extends PageQuery {

  /**
   * 专家 id
   */
  expertId?: string | number;

  /**
   * 用户 id
   */
  userId?: string | number;

  /**
   * 推荐专家姓名
   */
  expertName?: string;

  /**
   * 专家手机号
   */
  expertPhone?: string;

  /**
   * 推荐理由
   */
  reason?: string;

  /**
   * 推荐状态 1 待审批 2 通过 3 驳回
   */
  status?: string;

    /**
     * 日期范围参数
     */
    params?: any;
}



