export interface InvoiceVO {
  /**
   * 发票表id
   */
  id: string | number;

  /**
   * 发票号码
   */
  invoiceNumber: number;

  /**
   * 发票金额
   */
  invoiceMoney: number;

  /**
   * 开票日期
   */
  startDate: string;

  /**
   * 专家名称
   */
  expertName: string;

  /**
   * 联系电话
   */
  expertPhone: string;

  /**
   * 专家身份证号
   */
  expertIdNumber: string | number;

  /**
   * 专家类型
   */
  expertType: string;

  /**
   * 电子发票地址ossId
   */
  invoiceAttached: string;

  /**
   * 电子发票地址
   */
  invoiceAttachedAddr: string;

  /**
   * 电子发票名字
   */
  invoiceAttachedName: string;

  expertTitleLevel: any

}

export interface InvoiceForm extends BaseEntity {
  /**
   * 发票表id
   */
  id?: string | number;

  /**
   * 发票号码
   */
  invoiceNumber?: number;

  /**
   * 发票金额
   */
  invoiceMoney?: number;

  /**
   * 开票日期
   */
  startDate?: string;

  /**
   * 专家名称
   */
  expertName?: string;

  /**
   * 联系电话
   */
  expertPhone?: string;

  /**
   * 专家身份证号
   */
  expertIdNumber?: string | number;

  /**
   * 专家类型
   */
  expertTitleLevel?: string;

  /**
   * 电子发票地址ossId
   */
  invoiceAttached?: string;

  /**
   * 电子发票地址
   */
  invoiceAttachedAddr?: string;

  /**
   * 电子发票名字
   */
  invoiceAttachedName?: string;

  /* 项目名称 */
  productId: string | number;
  /* 项目阶段 */
  reviewSn: string | number;
  /* 结算单 */
  settleId: string | number;

}

export interface InvoiceQuery extends PageQuery {

  /**
   * 发票号码
   */
  invoiceNumber?: number;

  /**
   * 发票金额
   */
  invoiceMoney?: number;

  /**
   * 开票日期
   */
  startDate?: string;

  /**
   * 专家名称
   */
  expertName?: string;

  /**
   * 联系电话
   */
  expertPhone?: string;

  /**
   * 专家身份证号
   */
  expertIdNumber?: string | number;

  /**
   * 专家类型
   */
  expertTitleLevel?: string;

  /**
   * 电子发票地址
   */
  invoiceAttached?: string;

  /**
   * 日期范围参数
   */
  params?: any;
}
