import request from '@/utils/request';
import { AxiosPromise } from 'axios';

export const getTableList = (params?: any): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/inoutCheck/list',
    method: 'get',
    params
  });
};


export const addReconciliation = (data:any): AxiosPromise<any> => {
  return request({
    url:'/zjk-api/inoutCheck/add',
    method:'post',
    data
  })
}


export const delReconciliation = (id:any): AxiosPromise<any> => {
  return request({
    url:'/zjk-api/inoutCheck/delete/' + id,
    method:'get',
  })
}

export const getDetailList = (params?: any): AxiosPromise<any> => {
  const { id, ...other } = params;
  delete other.total;
  return request({
    url: '/zjk-api/invReport/' + id,
    method: 'get',
    params: {
      ...other
    }
  });
};
