import request from '@/utils/request';
import { AxiosPromise } from 'axios';

export const getTableList = (params?: any): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/moneyInfo/list', method: 'get', params
  });
};

export const settlementManage = (params?: any): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/moneyInfo/update-settlement', method: 'post', data: params
  });
};

export const AddSettlement = (data?: any): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/moneyInfo/add', method: 'post', data
  });
};

export const UpdateSettlement = (data?: any): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/moneyInfo/edit', method: 'post', data
  });
};

export const DeleteSettlement = (id?: any): AxiosPromise<any> => {
  return request({
    url: `/zjk-api/moneyInfo/delete/${id}`, method: 'get'
  });
};

export const getDetail = (id?: any): AxiosPromise<any[]> => {
  return request({
    url: `/zjk-api/moneyInfo/${id}`, method: 'get'
  });
};
