import request from '@/utils/request';
import { AxiosPromise } from 'axios';

export const getTableList = (params?: any): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/invReport/list',
    method: 'get',
    params
  });
};

export const getDetailList = (params?: any): AxiosPromise<any> => {
  const { id, ...other } = params;
  delete other.total;
  return request({
    url: '/zjk-api/invReport/' + id,
    method: 'get',
    params: {
      ...other
    }
  });
};
