import request from '@/utils/request';
import { AxiosPromise } from 'axios';

export const getTableList = (query?: any): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/point/rewardList',
    method: 'get',
    params: query
  });
};
export const addMotivate = (query: any): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/point/addReward',
    method: 'post',
    data: query
  });
};
export const updateMotivate = (query: any): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/point/updateReward',
    method: 'post',
    data: query
  });
};
export const setStatus = (query: any): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/point/updateRewardStatus',
    method: 'post',
    data: query
  });
};
export const deleteMotivate = (id: any): AxiosPromise<any> => {
  return request({
    url: `/zjk-api/point/deleteReward/${id}`,
    method: 'get',
  });
};
