import request from '@/utils/request';
import { AxiosPromise } from 'axios';
import { ExtractVO, ExtractQuery, ExtractFormTypes, ResultListType } from './types';

export const getTableList = (query?: ExtractQuery): AxiosPromise<ExtractVO[]> => {
  return request({
    url: '/zjk-api/itemExtreation/list',
    method: 'get',
    params: query
  });
};
// 获取抽取信息
export const ExtractAjax = (query?: any): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/project/extract/expertltem',
    method: 'post',
    data: query
  });
};
export const CancelAjax = (query?: any): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/project/extract/cancel',
    method: 'post',
    data: query
  });
};
// 获取项目列表
export const getProjectSelList = (): AxiosPromise<any> => {
  return request({
    url: `/zjk-api/product/queryByList`,
    method: 'get'
  });
};
// 获取专家列表
export const getExpertSelList = (name): AxiosPromise<any> => {
  return request({
    url: `/zjk-api/project/extract/concatenated`,
    method: 'get',
    params: {
      name
    }
  });
};
// 获取单位列表
export const getUnitSelList = (name): AxiosPromise<any> => {
  return request({
    url: `/zjk-api/project/extract/unitList`,
    method: 'get',
    params: {
      name
    }
  });
};

export const getDict = (dictType: string): AxiosPromise<any> => {
  return request({
    url: `/system/dict/data/type/${dictType}`,
    method: 'get'
  });
};

export const getExtractInfo = (id: string): AxiosPromise<any> => {
  return request({
    url: `/zjk-api/itemExtreation/${id}`,
    method: 'get'
  });
};

export const getResult = (id: string): AxiosPromise<any> => {
  return request({
    url: `/zjk-api/itemExtreation/extraction/${id}`,
    method: 'get'
  });
};

export const getArea = (): AxiosPromise<any> => {
  return request({
    url: '/system/area/getProvince',
    method: 'get'
  });
};

export const getCity = (id): AxiosPromise<any> => {
  return request({
    url: '/system/area/cities/' + id,
    method: 'get'
  });
};
export const getRegionName = (query): AxiosPromise<any> => {
  return request({
    url: '/system/area/getRegionNames',
    method: 'get',
    params: query
  });
};

export const confirmExtractAjax = (query?: any): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/project/extract/update',
    method: 'post',
    data: query
  });
};


export const getExpertList = (query?: any): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/project/extract/get-expert',
    method: 'get',
    params: query
  });
};