import request from '@/utils/request';
import { AxiosPromise } from 'axios';
import { ExtractLogVO, ExtractLogQuery } from './types';

export const getTableList = (query?: ExtractLogQuery): AxiosPromise<ExtractLogVO[]> => {
  return request({
    url: '/zjk-api/project/extract/list',
    method: 'get',
    params: query
  });
};
export const getExpert = (id: string | number): AxiosPromise<ExtractLogVO> => {
  return request({
    url: '/zjk-api/expert/' + id,
    method: 'get'
  });
};
