import request from '@/utils/request';
import { AxiosPromise } from 'axios';

interface paramsQuery {
  pageNum: string | number;
  pageSize: number;
  createBy: string;
}
export const getFeedbackList = (query?: paramsQuery): AxiosPromise<{code: number, rows:any[], total:number}> => {
  return request({
    url: '/zjk-api/learningBack/list',
    method: 'get',
    params: query
  });
};

export const getLogs = (): AxiosPromise<any[]> => {
  return request({
    url:'zjk-api/learningBack/myList',
    method: 'get',
  })
}


export const setFeedback = (data: any): AxiosPromise<any[]> => {
  return request({
    url: '/zjk/learningBack/add',
    method: 'post',
    data: data
  });
};

export const delFeedback = (id: string | number) => {
  return request({
    url: '/zjk-api/learningBack/delete/' + id,
    method: 'get'
  });
}
