import { RouterJumpVo } from '@/api/workflow/workflowCommon/types';

export default {
  routerJump(routerJumpVo: RouterJumpVo, proxy) {
    if (routerJumpVo.wfNodeConfigVo && routerJumpVo.wfNodeConfigVo.formType === 'static' && routerJumpVo.wfNodeConfigVo.wfFormManageVo) {
      proxy.$tab.closePage(proxy.$route);
      if(routerJumpVo.wfNodeConfigVo.wfFormManageVo.router == 'workflow/leave/index'){
        proxy.$router.push({
          path: `/workflow/leaveEdit/index`,
          query: {
            id: routerJumpVo.businessKey,
            type: routerJumpVo.type,
            taskId: routerJumpVo.taskId,
            businessStatus: routerJumpVo.businessStatus,
            businessKey: routerJumpVo.businessKey,
            processInstanceId: routerJumpVo.processInstanceId
          }
        });
      }else if(routerJumpVo.wfNodeConfigVo.wfFormManageVo.router == 'leave/apply/index'){
        proxy.$router.push({
          path: `/leave/apply`,
          query: {
            id: routerJumpVo.businessKey,
            type: routerJumpVo.type,
            taskId: routerJumpVo.taskId,
            businessStatus: routerJumpVo.businessStatus,
            businessKey: routerJumpVo.businessKey,
            processInstanceId: routerJumpVo.processInstanceId
          }
        });
      }else{
        proxy.$router.push({
          path: `${routerJumpVo.wfNodeConfigVo.wfFormManageVo.router}`,
          query: {
            id: routerJumpVo.businessKey,
            type: routerJumpVo.type,
            taskId: routerJumpVo.taskId,
            businessStatus: routerJumpVo.businessStatus,
            businessKey: routerJumpVo.businessKey,
            processInstanceId: routerJumpVo.processInstanceId
          }
        });
      }
      // proxy.$router.push({
      //   path: `${routerJumpVo.wfNodeConfigVo.wfFormManageVo.router}`,
      //   query: {
      //     id: routerJumpVo.businessKey,
      //     type: routerJumpVo.type,
      //     taskId: routerJumpVo.taskId
      //   }
      // });
    } else if (routerJumpVo.wfNodeConfigVo && routerJumpVo.wfNodeConfigVo.formType === 'dynamic' && routerJumpVo.wfNodeConfigVo.wfFormManageVo) {
      proxy.$tab.closePage(proxy.$route);
      proxy.$router.push({
        path: `${routerJumpVo.wfNodeConfigVo.wfFormManageVo.router}`,
        query: {
          id: routerJumpVo.businessKey,
          type: routerJumpVo.type,
          taskId: routerJumpVo.taskId,
          businessStatus: routerJumpVo.businessStatus,
          businessKey: routerJumpVo.businessKey,
          processInstanceId: routerJumpVo.processInstanceId
        }
      });
    } else {
      proxy?.$modal.msgError('请到模型配置菜单！');
    }
  }
};
